/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;

public class JSONUtils {
    public static boolean areRequirementsMet(JsonObject object) {
        if (object.has("requirements")) {
            JsonArray present;
            JsonObject conditions = object.getAsJsonObject("requirements");
            if (conditions.has("present")) {
                present = conditions.getAsJsonArray("present");
                for (JsonElement mod : present) {
                    if (ModList.get().isLoaded(mod.getAsString())) continue;
                    return false;
                }
            }
            if (conditions.has("absent")) {
                present = conditions.getAsJsonArray("absent");
                for (JsonElement mod : present) {
                    if (!ModList.get().isLoaded(mod.getAsString())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockState deserializeBlockStateProperties(Block block, JsonObject element) {
        BlockState state = block.defaultBlockState();
        if (element.has("properties")) {
            JsonObject data = element.get("properties").getAsJsonObject();
            for (Property property : state.getProperties()) {
                if (!data.has(property.getName())) continue;
                state = JSONUtils.parseProperty(state, property, data.get(property.getName()).getAsString());
            }
        }
        return state;
    }

    public static int getWeight(JsonObject object) {
        return object.has("weight") ? object.get("weight").getAsInt() : 1;
    }

    public static Vec3i getOffset(JsonObject jsonObject) {
        int x = 0;
        int y = 0;
        int z = 0;
        if (jsonObject.has("x")) {
            x = jsonObject.get("x").getAsInt();
        }
        if (jsonObject.has("y")) {
            y = jsonObject.get("y").getAsInt();
        }
        if (jsonObject.has("z")) {
            z = jsonObject.get("z").getAsInt();
        }
        if (x == 0 && y == 0 && z == 0) {
            return DungeonModels.NO_OFFSET;
        }
        return new Vec3i(x, y, z);
    }

    private static <T extends Comparable<T>> BlockState parseProperty(BlockState state, Property<T> property, String value) {
        Optional optional = property.getValue(value);
        if (optional.isPresent()) {
            Comparable t = (Comparable)optional.get();
            return (BlockState)state.setValue(property, t);
        }
        DungeonCrawl.LOGGER.warn("Couldn't apply property {} with value {} to {}", (Object)property.getName(), (Object)value, (Object)BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
        return state;
    }

    public static JsonObject serializeBlockState(JsonObject object, BlockState state) {
        Block block = state.getBlock();
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (registryName == null) {
            DungeonCrawl.LOGGER.error("No registry name found for block {} ({})", (Object)block, block.getClass());
            return new JsonObject();
        }
        object.addProperty("block", registryName.toString());
        BlockState defaultState = block.defaultBlockState();
        JsonObject properties = new JsonObject();
        state.getProperties().forEach(property -> {
            if (!state.getValue(property).equals(defaultState.getValue(property))) {
                properties.addProperty(property.getName(), state.getValue(property).toString());
            }
        });
        if (properties.size() > 0) {
            object.add("properties", (JsonElement)properties);
        }
        return object;
    }
}

