/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.data.material.MaterialBuilder;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.util.DataResource;
import org.jetbrains.annotations.NotNull;

public abstract class MaterialsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public MaterialsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    protected abstract Collection<MaterialBuilder<?>> getMaterials();

    protected DataResource<Material> modId(String path) {
        return DataResource.material(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)path));
    }

    protected static ResourceLocation commonId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }

    @NotNull
    public String getName() {
        return "Silent Gear Materials: " + this.modId;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.getMaterials().forEach(builder -> {
            if (!set.add(builder.getId())) {
                throw new IllegalStateException("Duplicate material: " + String.valueOf(builder.getId()));
            }
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_materials/%s.json", builder.getId().getNamespace(), builder.getId().getPath()));
            list.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)builder.serialize(), (Path)path));
        });
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }
}

