/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.block.press.MetalPressBlockEntity;
import net.silentchaos512.gear.setup.SgMenuTypes;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;

public class MetalPressContainer
extends AbstractContainerMenu {
    private final Container inventory;
    private final ContainerData fields;

    public MetalPressContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(1));
    }

    public MetalPressContainer(int id, Inventory playerInventory, Container inventory, ContainerData fields) {
        super((MenuType)SgMenuTypes.METAL_PRESS.get(), id);
        this.inventory = inventory;
        this.fields = fields;
        this.addSlot(new Slot(this.inventory, 0, 56, 35));
        this.addSlot((Slot)new SlotOutputOnly(this.inventory, 1, 117, 35));
        InventoryUtils.createPlayerSlots((Inventory)playerInventory, (int)8, (int)84).forEach(x$0 -> this.addSlot((Slot)x$0));
        this.addDataSlots(this.fields);
    }

    public int getProgressArrowScale() {
        int progress = this.fields.get(0);
        return progress != 0 ? progress * 24 / MetalPressBlockEntity.WORK_TIME : 0;
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int inventorySize = 2;
            int playerInventoryEnd = 29;
            int playerHotbarEnd = 38;
            if (index == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 0 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : !this.moveItemStackTo(itemstack1, 2, 38, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }
}

