/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.stoneanvil;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.silentchaos512.gear.crafting.recipe.ToolActionRecipe;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public class StoneAnvilBlockEntity
extends BlockEntity
implements Clearable {
    private ItemStack item = ItemStack.EMPTY;
    private final RecipeManager.CachedCheck<ToolActionRecipe.Input, ToolActionRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)SgRecipes.TOOL_ACTION_TYPE.get()));

    public StoneAnvilBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)SgBlockEntities.STONE_ANVIL.get(), pPos, pBlockState);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Optional<RecipeHolder<ToolActionRecipe>> getRecipe(ItemStack tool, ItemStack item) {
        if (item.isEmpty() || this.level == null) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor((RecipeInput)new ToolActionRecipe.Input(tool, item), this.level);
    }

    public boolean interact(LivingEntity entity, ItemStack stack, InteractionHand hand) {
        if (this.item.isEmpty()) {
            this.placeItem(entity, stack);
            return true;
        }
        if (this.workOnItem(entity, stack, hand)) {
            return true;
        }
        return this.takeItem(entity);
    }

    public void placeItem(LivingEntity entity, ItemStack stack) {
        this.item = stack.split(stack.getCount());
        if (this.level != null) {
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
        }
        this.markUpdated();
    }

    public boolean takeItem(LivingEntity entity) {
        if (!this.item.isEmpty()) {
            this.dropItem(this.item);
            this.clearContent();
            if (this.level != null) {
                this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            }
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean workOnItem(LivingEntity entity, ItemStack tool, InteractionHand hand) {
        if (GearHelper.isGear(tool) && GearHelper.isBroken(tool)) {
            return false;
        }
        Optional<RecipeHolder<ToolActionRecipe>> optionalHolder = this.getRecipe(tool, this.item);
        if (optionalHolder.isPresent() && this.level != null) {
            ServerPlayer serverPlayer;
            ToolActionRecipe recipe = (ToolActionRecipe)optionalHolder.get().value();
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            int damage = recipe.getDamageToTool();
            this.dropItem(result.copy());
            this.item.shrink(1);
            ServerPlayer serverPlayer2 = serverPlayer = entity instanceof ServerPlayer ? (ServerPlayer)entity : null;
            if (serverPlayer == null || !serverPlayer.getAbilities().instabuild) {
                tool.hurtAndBreak(damage, entity, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            recipe.getSound().playAt(this.level, this.getBlockPos(), SoundSource.PLAYERS);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    public void dropItem(ItemStack stack) {
        if (this.level != null) {
            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)((double)this.getBlockPos().getY() + 1.0), (double)this.getBlockPos().getZ(), (ItemStack)stack);
        }
    }

    private void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void clearContent() {
        this.item = ItemStack.EMPTY;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.item = ItemStack.EMPTY;
        this.item = tag.contains("Item") ? (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("Item")).orElse(null) : ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.item.isEmpty()) {
            tag.put("Item", this.item.save(provider));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (!this.item.isEmpty()) {
            tag.put("Item", this.item.save(provider));
        }
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        CompoundTag tag = pkt.getTag();
        this.item = tag.contains("Item") ? (ItemStack)ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)tag.getCompound("Item")).orElse(null) : ItemStack.EMPTY;
    }
}

