/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.curios;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.silentchaos512.gear.compat.caelus.CaelusCompat;
import net.silentchaos512.gear.item.gear.GearElytraItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioGearItemCapability {
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new GearCurio((ItemStack)stack, multimap -> {}), new ItemLike[]{GearItemSets.BRACELET.gearItem(), GearItemSets.RING.gearItem(), GearItemSets.NECKLACE.gearItem()});
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new GearCurio((ItemStack)stack, builder -> GearItemSets.ELYTRA.gearItem().addAttributes((ItemStack)stack, (ItemAttributeModifiers.Builder)builder, false), (ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(stack, extraAttributes);
            }

            @Override
            public void curioTick(SlotContext context) {
                if (context.entity().level().isClientSide || !ElytraItem.isFlyEnabled((ItemStack)this.val$stack)) {
                    return;
                }
                int ticksFlying = context.entity().getFallFlyingTicks();
                if ((ticksFlying + 1) % 20 == 0) {
                    this.val$stack.hurtAndBreak(1, context.entity(), EquipmentSlot.BODY);
                }
            }
        }, new ItemLike[]{GearItemSets.ELYTRA.gearItem()});
    }

    public static class GearCurio
    implements ICurio {
        private final ItemStack stack;
        private final Consumer<ItemAttributeModifiers.Builder> extraAttributes;

        private GearCurio() {
            this(ItemStack.EMPTY, multimap -> {});
        }

        private GearCurio(ItemStack stack, Consumer<ItemAttributeModifiers.Builder> extraAttributes) {
            this.stack = stack;
            this.extraAttributes = extraAttributes;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            GearHelper.inventoryTick(this.stack, slotContext.entity().level(), (Entity)slotContext.entity(), -1, true);
        }

        public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id) {
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            GearHelper.addAttributeModifiers(this.stack, builder, false);
            ItemAttributeModifiers itemAttributeModifiers = builder.build();
            ArrayListMultimap result = ArrayListMultimap.create();
            itemAttributeModifiers.modifiers().forEach(arg_0 -> GearCurio.lambda$getAttributeModifiers$1((Multimap)result, arg_0));
            if (this.stack.getItem() instanceof GearElytraItem) {
                CaelusCompat.tryAddFlightAttribute((Multimap<Holder<Attribute>, AttributeModifier>)result);
            }
            return result;
        }

        public boolean makesPiglinsNeutral(SlotContext slotContext) {
            return TraitHelper.hasTrait(this.stack, Const.Traits.BRILLIANT);
        }

        public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
            return 0;
        }

        public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
            return 0;
        }

        @NotNull
        public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit) {
            return ICurio.DropRule.ALWAYS_KEEP;
        }

        public boolean canEquipFromUse(SlotContext slotContext) {
            return true;
        }

        @Nonnull
        public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
            return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value(), 1.0f, 1.0f);
        }

        private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap result, ItemAttributeModifiers.Entry entry) {
            result.put((Object)entry.attribute(), (Object)entry.modifier());
        }
    }
}

