/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.recipe.ToolActionRecipe;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.util.TextUtil;

public class ToolActionRecipeCategory
implements IRecipeCategory<ToolActionRecipe> {
    private static final ResourceLocation TEXTURE = SilentGear.getId("textures/gui/tool_action_jei.png");
    private static final int GUI_START_X = 0;
    private static final int GUI_START_Y = 0;
    private static final int GUI_WIDTH = 100;
    private static final int GUI_HEIGHT = 41;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public ToolActionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 100, 41);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(SgBlocks.STONE_ANVIL));
        this.localizedName = TextUtil.translate("jei", "group.tool_action");
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 41;
    }

    public RecipeType<ToolActionRecipe> getRecipeType() {
        return SGearJeiPlugin.TOOL_ACTION_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ToolActionRecipe recipe, IFocusGroup focus) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addIngredients(recipe.getTool());
        builder.addSlot(RecipeIngredientRole.INPUT, 22, 3).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 22, 22).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)SgBlocks.STONE_ANVIL.get()}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 12).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getResult()}));
    }

    public void draw(ToolActionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }
}

