/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.gear.PartTypes;

interface IGearRecipe {
    public GearItem getOutputItem();

    default public Collection<PartInstance> getParts(CraftingInput inv) {
        ArrayList<MaterialInstance> materials = new ArrayList<MaterialInstance>();
        Material first = null;
        ArrayList<PartInstance> parts = new ArrayList<PartInstance>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat != null) {
                if (first == null) {
                    first = mat.get();
                } else if (first != mat.get()) {
                    return Collections.emptyList();
                }
                materials.add(mat);
                continue;
            }
            PartInstance part = PartInstance.from(stack);
            if (part == null) continue;
            parts.add(part);
        }
        if (!materials.isEmpty()) {
            IGearRecipe.createToolHead(this.getOutputItem().getGearType(), materials).ifPresent(parts::addFirst);
        }
        return parts;
    }

    public static Optional<PartInstance> createToolHead(GearType gearType, List<MaterialInstance> materials) {
        return IGearRecipe.createCompoundPart(gearType, (PartType)PartTypes.MAIN.get(), materials);
    }

    public static Optional<PartInstance> createCompoundPart(GearType gearType, PartType partType, List<MaterialInstance> materials) {
        return partType.getCompoundPartItem(gearType).map(item -> {
            ItemStack stack = item.create(materials);
            return PartInstance.from(stack);
        });
    }
}

