/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.crafting.recipe.IGearRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;

public final class ShapedGearRecipe
extends ExtendedShapedRecipe
implements IGearRecipe {
    private final GearItem item;
    private final Lazy<ItemStack> exampleOutput;

    public ShapedGearRecipe(String pGroup, CraftingBookCategory pCategory, ShapedRecipePattern pPattern, ItemStack pResult, boolean pShowNotification) {
        super(pGroup, pCategory, pPattern, pResult, pShowNotification);
        if (!(pResult.getItem() instanceof GearItem)) {
            throw new JsonParseException("result is not a gear item: " + String.valueOf(pResult));
        }
        this.item = (GearItem)pResult.getItem();
        this.exampleOutput = Lazy.of(() -> {
            ItemStack result = this.item.construct(GearHelper.getExamplePartsFromRecipe(this.item.getGearType(), (Iterable<Ingredient>)this.getIngredients()));
            GearData.setExampleTag(result, true);
            return result;
        });
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SgRecipes.SHAPED_GEAR.get();
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        if (!super.matches(inv, worldIn)) {
            return false;
        }
        GearType gearType = this.item.getGearType();
        for (PartInstance part : this.getParts(inv)) {
            if (part.isCraftingAllowed(gearType, inv)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        return this.item.construct(this.getParts(inv));
    }

    @Override
    public GearItem getOutputItem() {
        return this.item;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return (ItemStack)this.exampleOutput.get();
    }

    public boolean isSpecial() {
        return true;
    }
}

