/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.part.PartCraftingData;
import net.silentchaos512.gear.api.part.PartDisplayData;
import net.silentchaos512.gear.api.part.PartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearHelper;

public class UpgradeGearPart
extends CoreGearPart {
    private final GearTypeMatcher upgradeGearTypes;

    public UpgradeGearPart(GearType gearType, PartType partType, GearTypeMatcher upgradeGearTypes, PartCraftingData crafting, PartDisplayData display, GearPropertyMap properties) {
        super(gearType, partType, crafting, display, properties);
        this.upgradeGearTypes = upgradeGearTypes;
    }

    @Override
    public PartType getType() {
        return (PartType)PartTypes.MISC_UPGRADE.get();
    }

    @Override
    public PartSerializer<?> getSerializer() {
        return (PartSerializer)PartSerializers.UPGRADE.get();
    }

    @Override
    public int getColor(PartInstance part, GearType gearType, int layer, int animationFrame) {
        return 0xFFFFFF;
    }

    @Override
    public void addInformation(PartInstance part, ItemStack gear, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, part.getDisplayName(this.partType));
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartInstance part) {
        return this.upgradeGearTypes.test(GearHelper.getType(gear));
    }

    public static class Serializer
    extends PartSerializer<UpgradeGearPart> {
        private static final MapCodec<UpgradeGearPart> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GearType.CODEC.fieldOf("gear_type").forGetter(p -> p.gearType), (App)PartType.CODEC.fieldOf("part_type").forGetter(p -> p.partType), (App)GearTypeMatcher.CODEC.fieldOf("upgrade_gear_types").forGetter(p -> p.upgradeGearTypes), (App)PartCraftingData.CODEC.fieldOf("crafting").forGetter(p -> p.crafting), (App)PartDisplayData.CODEC.fieldOf("display").forGetter(p -> p.display), (App)GearPropertyMap.CODEC.fieldOf("properties").forGetter(p -> p.properties)).apply((Applicative)instance, UpgradeGearPart::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, UpgradeGearPart> STREAM_CODEC = StreamCodec.composite(GearType.STREAM_CODEC, p -> p.gearType, PartType.STREAM_CODEC, p -> p.partType, GearTypeMatcher.STREAM_CODEC, p -> p.upgradeGearTypes, PartCraftingData.STREAM_CODEC, p -> p.crafting, PartDisplayData.STREAM_CODEC, p -> p.display, GearPropertyMap.STREAM_CODEC, p -> p.properties, UpgradeGearPart::new);

        public Serializer() {
            super(CODEC, STREAM_CODEC);
        }
    }
}

