/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.CodecUtils;

public class NegateDamageTraitEffect
extends TraitEffect {
    public static final MapCodec<NegateDamageTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("damage_type_tag").forGetter(e -> e.damageType), (App)Codec.FLOAT.fieldOf("negated_damage_scale").forGetter(e -> Float.valueOf(e.negatedDamageScale))).apply((Applicative)instance, NegateDamageTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NegateDamageTraitEffect> STREAM_CODEC = StreamCodec.composite(CodecUtils.tagStreamCodec(Registries.DAMAGE_TYPE), e -> e.damageType, (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.negatedDamageScale), NegateDamageTraitEffect::new);
    private final TagKey<DamageType> damageType;
    private final float negatedDamageScale;

    public NegateDamageTraitEffect(TagKey<DamageType> damageType, float negatedDamageScale) {
        this.damageType = damageType;
        this.negatedDamageScale = negatedDamageScale;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.NEGATE_DAMAGE.get();
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return List.of(String.format("  - Reduces \"%s\" type damage by %d%% per level per armor piece", this.damageType.location(), (int)(this.negatedDamageScale * 100.0f)));
    }

    @Override
    public float onEntityIncomingDamage(ItemStack armor, int traitLevel, LivingEntity target, DamageSource source, float amount, float originalAmount) {
        if (source.is(this.damageType)) {
            float reduction = originalAmount * this.negatedDamageScale * (float)traitLevel;
            return Mth.clamp((float)(amount - reduction), (float)0.0f, (float)amount);
        }
        return amount;
    }
}

