/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.gear.PartTypes;

public class MainPartItem
extends CompoundPartItem {
    private final Supplier<GearType> gearType;

    public MainPartItem(Supplier<GearType> gearType, Item.Properties properties) {
        super((Supplier<PartType>)PartTypes.MAIN, properties.durability(100));
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public int getColorWeight(int index, int totalCount) {
        int diff = super.getColorWeight(index, totalCount);
        return diff * diff;
    }

    public int getMaxDamage(ItemStack stack) {
        PartInstance part = PartInstance.from(stack);
        if (part != null) {
            PropertyKey key = PropertyKey.of(this.getGearType().durabilityStat().get(), this.getGearType());
            return Math.round(((Float)part.getProperty((Supplier<PartType>)PartTypes.MAIN, key)).floatValue());
        }
        return super.getMaxDamage(stack);
    }
}

