/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgArmorMaterials;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class GearArmorItem
extends ArmorItem
implements GearArmor {
    private static final Cache<String, Integer> ARMOR_COLORS = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final Supplier<GearType> gearType;

    public GearArmorItem(Supplier<GearType> gearType, ArmorItem.Type armorType) {
        super(SgArmorMaterials.DUMMY, armorType, GearHelper.getBaseItemProperties());
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public boolean isValidSlot(String slot) {
        return this.getType().getSlot().getName().equalsIgnoreCase(slot);
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return this.getGearType().armorDurabilityMultiplier();
    }

    public float getArmorProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        return GearData.getProperties(stack).getNumber(GearProperties.ARMOR);
    }

    public float getArmorToughness(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        return GearData.getProperties(stack).getNumber(GearProperties.ARMOR_TOUGHNESS) / 4.0f;
    }

    public float getArmorMagicProtection(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        return GearData.getProperties(stack).getNumber(GearProperties.MAGIC_ARMOR);
    }

    private static float getGenericArmorProtection(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof GearArmorItem) {
            return ((GearArmorItem)item).getArmorProtection(stack);
        }
        if (item instanceof ArmorItem) {
            return ((ArmorItem)item).getDefense();
        }
        return 0.0f;
    }

    private static int getPlayerTotalArmorValue(LivingEntity player) {
        float total = 0.0f;
        for (ItemStack armor : player.getArmorSlots()) {
            total += GearArmorItem.getGenericArmorProtection(armor);
        }
        return Math.round(total);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlot slot = this.getEquipmentSlot();
        if (slot == this.getType().getSlot()) {
            EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
            ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)("armor." + this.getType().getName()));
            builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, (double)this.getArmorProtection(stack), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, (double)this.getArmorToughness(stack), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
            float knockbackResistance = GearData.getProperties(stack).getNumber(GearProperties.KNOCKBACK_RESISTANCE) / 10.0f;
            if (knockbackResistance > 0.0f) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
            }
            GearHelper.addAttributeModifiers(stack, builder, false);
        }
        return builder.build();
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamageFactor = (int)GearData.getProperties(stack).getNumber(this.getDurabilityStat());
        return (int)this.getGearType().armorDurabilityMultiplier() * maxDamageFactor;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.clamp((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, item -> {
            GearHelper.onBroken(stack, entity instanceof Player ? (Player)entity : null, this.getType().getSlot());
            onBroken.accept((Item)item);
        });
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantmentValue(stack);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean equipped = itemSlot >= 36 && itemSlot <= 39;
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, equipped);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        MaterialInstance primaryMaterial;
        if (GearHelper.isBroken(stack)) {
            return SilentGear.getId("textures/models/armor/empty.png");
        }
        PartInstance primaryPart = GearData.getConstruction(stack).getCoatingOrMainPart();
        if (primaryPart != null && (primaryMaterial = primaryPart.getPrimaryMaterial()) != null) {
            TextureType mainTextureType = primaryMaterial.getMainTextureType();
            return mainTextureType.getArmorTexture(innerModel);
        }
        return TextureType.HIGH_CONTRAST.getArmorTexture(innerModel);
    }

    public static int getArmorColor(ItemStack stack) {
        GearConstructionData data = GearData.getConstruction(stack);
        PartInstance part = data.getCoatingOrMainPart();
        if (part != null) {
            return part.getColor(stack);
        }
        return 0xFFFFFF;
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, tooltipContext, tooltip, flagIn);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

