/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.silentchaos512.gear.Config;
import net.silentchaos512.lib.util.Color;

public final class TextUtil {
    private TextUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static MutableComponent translate(String prefix, String suffix) {
        return Component.translatable((String)(prefix + ".silentgear." + suffix));
    }

    public static MutableComponent translate(String prefix, String suffix, Object ... args) {
        return Component.translatable((String)(prefix + ".silentgear." + suffix), (Object[])args);
    }

    public static MutableComponent misc(String key, Object ... args) {
        return TextUtil.translate("misc", key, args);
    }

    public static MutableComponent keyBinding(KeyMapping keyBinding) {
        return TextUtil.misc("key", keyBinding.getTranslatedKeyMessage());
    }

    public static MutableComponent withColor(MutableComponent text, int color) {
        return text.withStyle(text.getStyle().withColor(TextColor.fromRgb((int)(color & 0xFFFFFF))));
    }

    public static MutableComponent withColor(MutableComponent text, Color color) {
        return TextUtil.withColor(text, color.getColor());
    }

    public static MutableComponent withColor(MutableComponent text, ChatFormatting color) {
        int colorCode = color.getColor() != null ? color.getColor() : 0xFFFFFF;
        return TextUtil.withColor(text, colorCode);
    }

    public static MutableComponent separatedList(Collection<Component> list) {
        MutableComponent ret = null;
        for (Component c : list) {
            if (ret == null) {
                ret = c.copy();
                continue;
            }
            ret.append(", ").append((Component)c.copy());
        }
        return ret;
    }

    public static void addWipText(Collection<Component> tooltip) {
        if (((Boolean)Config.Common.showWipText.get()).booleanValue()) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("wip", new Object[0]), ChatFormatting.RED));
        }
    }
}

