/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.detail.ForgeDetailRegistries;
import dan200.computercraft.api.network.wired.WiredElementCapability;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.Services;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.CommonHooks;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.details.FluidData;
import dan200.computercraft.shared.integration.CreateIntegration;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.peripheral.commandblock.CommandBlockPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.EnergyMethods;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.platform.ForgeConfigFile;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@Mod(value="computercraft")
@EventBusSubscriber(modid="computercraft", bus=EventBusSubscriber.Bus.MOD)
public final class ComputerCraft {
    @Nullable
    private static IEventBus eventBus;

    public ComputerCraft(IEventBus eventBus) {
        ComputerCraft.withEventBus(eventBus, ModRegistry::register);
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)((ForgeConfigFile)ConfigSpec.serverSpec).spec());
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)((ForgeConfigFile)ConfigSpec.clientSpec).spec());
    }

    private static void withEventBus(IEventBus eventBus, Runnable task) {
        ComputerCraft.eventBus = eventBus;
        task.run();
        ComputerCraft.eventBus = null;
    }

    public static IEventBus getEventBus() {
        IEventBus bus = eventBus;
        if (bus == null) {
            throw new NullPointerException("Bus is not available.");
        }
        return bus;
    }

    @SubscribeEvent
    public static void registerRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder(ITurtleUpgrade.typeRegistry()));
        event.create(new RegistryBuilder(IPocketUpgrade.typeRegistry()));
        event.create(new RegistryBuilder(RecipeFunction.REGISTRY).sync(true));
    }

    @SubscribeEvent
    public static void registerDynamicRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ITurtleUpgrade.REGISTRY, TurtleUpgrades.instance().upgradeCodec(), TurtleUpgrades.instance().upgradeCodec());
        event.dataPackRegistry(IPocketUpgrade.REGISTRY, PocketUpgrades.instance().upgradeCodec(), PocketUpgrades.instance().upgradeCodec());
        event.dataPackRegistry(TurtleOverlay.REGISTRY, TurtleOverlay.DIRECT_CODEC, TurtleOverlay.DIRECT_CODEC);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(ModRegistry::registerMainThread);
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        ComputerCraftAPI.registerGenericSource(new FluidMethods());
        ComputerCraftAPI.registerGenericSource(new EnergyMethods());
        ForgeComputerCraftAPI.registerGenericCapability(Capabilities.ItemHandler.BLOCK);
        ForgeComputerCraftAPI.registerGenericCapability(Capabilities.FluidHandler.BLOCK);
        ForgeComputerCraftAPI.registerGenericCapability(Capabilities.EnergyStorage.BLOCK);
        ForgeDetailRegistries.FLUID_STACK.addProvider(FluidData::fill);
        if (ModList.get().isLoaded("create")) {
            event.enqueueWork(CreateIntegration::setup);
        }
    }

    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("computercraft").versioned(ComputerCraftAPI.getInstalledVersion());
        for (CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ? extends NetworkMessage<ServerNetworkContext>> typeAndCodec : NetworkMessages.getServerbound()) {
            ComputerCraft.registerServerbound(registrar, typeAndCodec);
        }
        for (CustomPacketPayload.TypeAndCodec typeAndCodec : NetworkMessages.getClientbound()) {
            ComputerCraft.registerClientbound(registrar, typeAndCodec);
        }
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> void registerServerbound(PayloadRegistrar registrar, CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, T> type) {
        registrar.playToServer(type.type(), type.codec(), (t, context) -> context.enqueueWork(() -> t.handle(() -> (ServerPlayer)context.player())));
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> void registerClientbound(PayloadRegistrar registrar, CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, T> type) {
        registrar.playToClient(type.type(), type.codec(), (t, context) -> context.enqueueWork(() -> t.handle(ClientHolderHolder.get())));
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.COMPUTER_NORMAL.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.COMPUTER_ADVANCED.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.TURTLE_NORMAL.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.TURTLE_ADVANCED.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.SPEAKER.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.PRINTER.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.DISK_DRIVE.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.MONITOR_NORMAL.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.MONITOR_ADVANCED.get(), (b, d) -> b.peripheral());
        event.registerBlockEntity(PeripheralCapability.get(), BlockEntityType.COMMAND_BLOCK, (b, d) -> Config.enableCommandBlock ? new CommandBlockPeripheral((CommandBlockEntity)b) : null);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.WIRELESS_MODEM_NORMAL.get(), WirelessModemBlockEntity::getPeripheral);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.WIRELESS_MODEM_ADVANCED.get(), WirelessModemBlockEntity::getPeripheral);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.WIRED_MODEM_FULL.get(), WiredModemFullBlockEntity::getPeripheral);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.CABLE.get(), CableBlockEntity::getPeripheral);
        event.registerBlockEntity(WiredElementCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.WIRED_MODEM_FULL.get(), (b, d) -> b.getElement());
        event.registerBlockEntity(WiredElementCapability.get(), (BlockEntityType)ModRegistry.BlockEntities.CABLE.get(), CableBlockEntity::getWiredElement);
    }

    @SubscribeEvent
    public static void sync(ModConfigEvent.Loading event) {
        ComputerCraft.syncConfig(event.getConfig());
    }

    @SubscribeEvent
    public static void sync(ModConfigEvent.Reloading event) {
        ComputerCraft.syncConfig(event.getConfig());
    }

    private static void syncConfig(ModConfig config) {
        if (!config.getModId().equals("computercraft")) {
            return;
        }
        Path path = config.getFullPath();
        if (config.getType() == ModConfig.Type.SERVER && ((ForgeConfigFile)ConfigSpec.serverSpec).spec().isLoaded()) {
            ConfigSpec.syncServer(path);
        } else if (config.getType() == ModConfig.Type.CLIENT) {
            ConfigSpec.syncClient(path);
        }
    }

    @SubscribeEvent
    public static void onCreativeTab(BuildCreativeModeTabContentsEvent event) {
        CommonHooks.onBuildCreativeTab((ResourceKey<CreativeModeTab>)event.getTabKey(), event.getParameters(), (CreativeModeTab.Output)event);
    }

    private static final class ClientHolderHolder {
        @Nullable
        private static final ClientNetworkContext INSTANCE;
        @Nullable
        private static final Throwable ERROR;

        private ClientHolderHolder() {
        }

        static ClientNetworkContext get() {
            ClientNetworkContext instance = INSTANCE;
            return instance == null ? Services.raise(ClientNetworkContext.class, ERROR) : instance;
        }

        static {
            Services.LoadedService<ClientNetworkContext> helper = Services.tryLoad(ClientNetworkContext.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

