/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.command.text.TableFormatter;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class ClientTableFormatter
implements TableFormatter {
    public static final ClientTableFormatter INSTANCE = new ClientTableFormatter();

    private static Font renderer() {
        return Minecraft.getInstance().font;
    }

    @Override
    @Nullable
    public Component getPadding(Component component, int width) {
        int extraWidth = width - this.getWidth(component);
        if (extraWidth <= 0) {
            return null;
        }
        Font renderer = ClientTableFormatter.renderer();
        float spaceWidth = renderer.width(" ");
        int spaces = Mth.floor((float)((float)extraWidth / spaceWidth));
        int extra = extraWidth - (int)((float)spaces * spaceWidth);
        return ChatHelpers.coloured(StringUtils.repeat((char)' ', (int)spaces) + StringUtils.repeat((char)'\u02c8', (int)extra), ChatFormatting.GRAY);
    }

    @Override
    public int getColumnPadding() {
        return 3;
    }

    @Override
    public int getWidth(Component component) {
        return ClientTableFormatter.renderer().width((FormattedText)component);
    }

    @Override
    public void writeLine(String label, Component component) {
        Minecraft mc = Minecraft.getInstance();
        ChatComponent chat = mc.gui.getChat();
        chat.addMessage(component, null, ClientTableFormatter.createTag(label));
    }

    @Override
    public void display(TableBuilder table) {
        ChatComponent chat = Minecraft.getInstance().gui.getChat();
        GuiMessageTag tag = ClientTableFormatter.createTag(table.getId());
        if (chat.allMessages.removeIf(guiMessage -> guiMessage.tag() != null && Objects.equals(guiMessage.tag().logTag(), tag.logTag()))) {
            chat.rescaleChat();
        }
        TableFormatter.super.display(table);
    }

    private static GuiMessageTag createTag(String id) {
        return new GuiMessageTag(0xA0A0A0, null, null, "ComputerCraft/" + id);
    }
}

