/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dan200.computercraft.client.model.LecternPrintoutModel;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomLecternRenderer
implements BlockEntityRenderer<CustomLecternBlockEntity> {
    private final LecternPrintoutModel printoutModel = new LecternPrintoutModel();

    public CustomLecternRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CustomLecternBlockEntity lectern, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.0625f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-((Direction)lectern.getBlockState().getValue((Property)LecternBlock.FACING)).getClockWise().toYRot()));
        poseStack.mulPose(Axis.ZP.rotationDegrees(67.5f));
        poseStack.translate(0.0f, -0.125f, 0.0f);
        ItemStack item = lectern.getItem();
        Item item2 = item.getItem();
        if (item2 instanceof PrintoutItem) {
            PrintoutItem printout = (PrintoutItem)item2;
            VertexConsumer vertexConsumer = LecternPrintoutModel.MATERIAL.buffer(buffer, RenderType::entitySolid);
            if (printout.getType() == PrintoutItem.Type.BOOK) {
                this.printoutModel.renderBook(poseStack, vertexConsumer, packedLight, packedOverlay);
            } else {
                this.printoutModel.renderPages(poseStack, vertexConsumer, packedLight, packedOverlay, PrintoutData.getOrEmpty((DataComponentHolder)item).pages());
            }
        }
        poseStack.popPose();
    }
}

