/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.turtle;

import dan200.computercraft.api.client.ModelLocation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModeller;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TurtleModemModeller
implements TurtleUpgradeModeller<TurtleModem> {
    @Override
    public TransformedModel getModel(TurtleModem upgrade, @Nullable ITurtleAccess turtle, TurtleSide side, DataComponentPatch data) {
        ModemModels models;
        boolean active = DataComponentUtil.isPresent(data, (DataComponentType)ModRegistry.DataComponents.ON.get(), x -> x);
        ModemModels modemModels = models = upgrade.advanced() ? ModemModels.ADVANCED : ModemModels.NORMAL;
        return side == TurtleSide.LEFT ? TransformedModel.of(active ? models.leftOnModel() : models.leftOffModel()) : TransformedModel.of(active ? models.rightOnModel() : models.rightOffModel());
    }

    @Override
    public Stream<ResourceLocation> getDependencies() {
        return Stream.of(ModemModels.NORMAL, ModemModels.ADVANCED).flatMap(ModemModels::getDependencies);
    }

    private record ModemModels(ModelLocation leftOffModel, ModelLocation rightOffModel, ModelLocation leftOnModel, ModelLocation rightOnModel) {
        private static final ModemModels NORMAL = ModemModels.create("normal");
        private static final ModemModels ADVANCED = ModemModels.create("advanced");

        public static ModemModels create(String type) {
            return new ModemModels(ModelLocation.ofResource(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/turtle_modem_" + type + "_off_left"))), ModelLocation.ofResource(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/turtle_modem_" + type + "_off_right"))), ModelLocation.ofResource(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/turtle_modem_" + type + "_on_left"))), ModelLocation.ofResource(ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("block/turtle_modem_" + type + "_on_right"))));
        }

        public Stream<ResourceLocation> getDependencies() {
            return Stream.of(this.leftOffModel, this.rightOffModel, this.leftOnModel, this.rightOnModel).flatMap(ModelLocation::getDependencies);
        }
    }
}

