/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.MountConstants;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.core.filesystem.AbstractInMemoryMount;
import dan200.computercraft.core.filesystem.FileFlags;
import dan200.computercraft.core.util.Nullability;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class MemoryMount
extends AbstractInMemoryMount<FileEntry>
implements WritableMount {
    private static final byte[] EMPTY = new byte[0];
    private final long capacity;

    public MemoryMount() {
        this(1000000000L);
    }

    public MemoryMount(long capacity) {
        this.capacity = capacity;
        this.root = new FileEntry();
        ((FileEntry)this.root).children = new HashMap();
    }

    public MemoryMount addFile(String file, byte[] contents, FileTime created, FileTime modified) {
        FileEntry entry = this.getOrCreateChild(Nullability.assertNonNull((FileEntry)this.root), file, x -> new FileEntry());
        entry.contents = contents;
        entry.length = contents.length;
        entry.created = created;
        entry.modified = modified;
        return this;
    }

    public MemoryMount addFile(String file, String contents, FileTime created, FileTime modified) {
        return this.addFile(file, contents.getBytes(StandardCharsets.UTF_8), created, modified);
    }

    public MemoryMount addFile(String file, byte[] contents) {
        return this.addFile(file, contents, MountConstants.EPOCH, MountConstants.EPOCH);
    }

    public MemoryMount addFile(String file, String contents) {
        return this.addFile(file, contents, MountConstants.EPOCH, MountConstants.EPOCH);
    }

    @Override
    protected long getSize(String path, FileEntry file) {
        return file.length;
    }

    @Override
    protected SeekableByteChannel openForRead(String path, FileEntry file) throws IOException {
        if (file.contents == null) {
            throw new FileOperationException(path, "Not a file");
        }
        return new EntryChannel(file, 0);
    }

    @Override
    protected BasicFileAttributes getAttributes(String path, FileEntry file) throws IOException {
        return new FileAttributes(file.isDirectory(), file.length, file.created, file.modified);
    }

    @Nullable
    private ParentAndName getParentAndName(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path is empty");
        }
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return new ParentAndName(Nullability.assertNonNull(Nullability.assertNonNull((FileEntry)this.root).children), path);
        }
        FileEntry entry = (FileEntry)this.get(path.substring(0, index));
        return entry == null || entry.children == null ? null : new ParentAndName(entry.children, path.substring(index + 1));
    }

    @Override
    public void makeDirectory(String path) throws IOException {
        if (path.isEmpty()) {
            return;
        }
        FileEntry lastEntry = Nullability.assertNonNull((FileEntry)this.root);
        int lastIndex = 0;
        while (lastIndex < path.length()) {
            String part;
            FileEntry nextEntry;
            if (lastEntry.children == null) {
                throw new NullPointerException("children is null");
            }
            int nextIndex = path.indexOf(47, lastIndex);
            if (nextIndex < 0) {
                nextIndex = path.length();
            }
            if ((nextEntry = (FileEntry)lastEntry.children.get(part = path.substring(lastIndex, nextIndex))) == null) {
                nextEntry = FileEntry.newDir();
                lastEntry.children.put(part, nextEntry);
            } else if (nextEntry.children == null) {
                throw new FileOperationException(path, "File exists");
            }
            lastEntry = nextEntry;
            lastIndex = nextIndex + 1;
        }
    }

    @Override
    public void delete(String path) throws IOException {
        if (path.isEmpty()) {
            throw new AccessDeniedException("Access denied");
        }
        ParentAndName node = this.getParentAndName(path);
        if (node != null) {
            node.parent().remove(node.name());
        }
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        if (dest.startsWith(source)) {
            throw new FileOperationException(source, "Cannot move a directory inside itself");
        }
        ParentAndName sourceParent = this.getParentAndName(source);
        if (sourceParent == null || !sourceParent.exists()) {
            throw new FileOperationException(source, "No such file");
        }
        ParentAndName destParent = this.getParentAndName(dest);
        if (destParent == null) {
            throw new FileOperationException(dest, "Parent directory does not exist");
        }
        if (destParent.exists()) {
            throw new FileOperationException(dest, "File exists");
        }
        destParent.put(sourceParent.parent().remove(sourceParent.name()));
    }

    @Override
    public SeekableByteChannel openFile(String path, Set<OpenOption> options) throws IOException {
        FileFlags flags = FileFlags.of(options);
        if (path.isEmpty()) {
            throw new FileOperationException(path, flags.create() ? "Cannot write to directory" : "Not a file");
        }
        ParentAndName parent = this.getParentAndName(path);
        if (parent == null) {
            throw new FileOperationException(path, "No such file");
        }
        FileEntry file = parent.get();
        if (file != null && file.isDirectory()) {
            throw new FileOperationException(path, flags.create() ? "Cannot write to directory" : "Not a file");
        }
        if (file == null) {
            if (!flags.create()) {
                throw new FileOperationException(path, "No such file");
            }
            file = FileEntry.newFile();
            parent.put(file);
        } else if (flags.truncate()) {
            file.contents = EMPTY;
            file.length = 0;
        }
        return new EntryChannel(file, flags.append() ? file.length : 0);
    }

    @Override
    public long getRemainingSpace() {
        return this.capacity - this.computeUsedSpace();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    private long computeUsedSpace() {
        FileEntry entry;
        ArrayDeque<FileEntry> queue = new ArrayDeque<FileEntry>();
        queue.add((FileEntry)this.root);
        long size = 0L;
        while ((entry = (FileEntry)queue.poll()) != null) {
            if (entry.children == null) {
                size += Math.max(500L, (long)Nullability.assertNonNull(entry.contents).length);
                continue;
            }
            size += 500L;
            queue.addAll(entry.children.values());
        }
        return size - 500L;
    }

    protected static final class FileEntry
    extends AbstractInMemoryMount.FileEntry<FileEntry> {
        FileTime created = MountConstants.EPOCH;
        FileTime modified = MountConstants.EPOCH;
        @Nullable
        byte[] contents;
        int length;

        protected FileEntry() {
        }

        static FileEntry newFile() {
            FileEntry entry = new FileEntry();
            entry.contents = EMPTY;
            entry.created = entry.modified = FileTime.from(Instant.now());
            return entry;
        }

        static FileEntry newDir() {
            FileEntry entry = new FileEntry();
            entry.children = new HashMap();
            entry.created = entry.modified = FileTime.from(Instant.now());
            return entry;
        }
    }

    private static final class EntryChannel
    implements SeekableByteChannel {
        private final FileEntry entry;
        private long position;
        private boolean isOpen = true;

        private void checkClosed() throws ClosedChannelException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
        }

        private EntryChannel(FileEntry entry, int position) {
            this.entry = entry;
            this.position = position;
        }

        @Override
        public int read(ByteBuffer destination) throws IOException {
            this.checkClosed();
            byte[] backing = Nullability.assertNonNull(this.entry.contents);
            if (this.position >= (long)this.entry.length) {
                return -1;
            }
            int remaining = Math.min(this.entry.length - (int)this.position, destination.remaining());
            destination.put(backing, (int)this.position, remaining);
            this.position += (long)remaining;
            return remaining;
        }

        private byte[] ensureCapacity(int capacity) {
            byte[] contents = Nullability.assertNonNull(this.entry.contents);
            if (capacity >= contents.length) {
                int newCapacity = Math.max(capacity, contents.length << 1);
                contents = this.entry.contents = Arrays.copyOf(contents, newCapacity);
            }
            return contents;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int toWrite = src.remaining();
            long endPosition = this.position + (long)toWrite;
            if (endPosition > 0x40000000L) {
                throw new IOException("File is too large");
            }
            byte[] contents = this.ensureCapacity((int)endPosition);
            src.get(contents, (int)this.position, toWrite);
            this.position = endPosition;
            if (endPosition > (long)this.entry.length) {
                this.entry.length = (int)endPosition;
            }
            return toWrite;
        }

        @Override
        public long position() throws IOException {
            this.checkClosed();
            return this.position;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.checkClosed();
            if (newPosition < 0L) {
                throw new IllegalArgumentException("Position out of bounds");
            }
            this.position = newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            this.checkClosed();
            return this.entry.length;
        }

        @Override
        public SeekableByteChannel truncate(long size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return this.isOpen && this.entry.contents != null;
        }

        @Override
        public void close() throws IOException {
            this.checkClosed();
            this.isOpen = false;
        }
    }

    private record ParentAndName(Map<String, FileEntry> parent, String name) {
        boolean exists() {
            return this.parent.containsKey(this.name);
        }

        @Nullable
        FileEntry get() {
            return this.parent.get(this.name);
        }

        void put(FileEntry entry) {
            assert (!this.parent.containsKey(this.name));
            this.parent.put(this.name, entry);
        }
    }
}

