/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.shared.ModRegistry;
import java.util.Optional;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class ItemModelProvider {
    private ItemModelProvider() {
    }

    public static void addItemModels(ItemModelGenerators generators) {
        ItemModelProvider.registerDisk(generators, (Item)ModRegistry.Items.DISK.get());
        ItemModelProvider.registerDisk(generators, (Item)ModRegistry.Items.TREASURE_DISK.get());
        ItemModelProvider.registerPocketComputer(generators, ModelLocationUtils.getModelLocation((Item)((Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())), false);
        ItemModelProvider.registerPocketComputer(generators, ModelLocationUtils.getModelLocation((Item)((Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())), false);
        ItemModelProvider.registerPocketComputer(generators, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_colour"), true);
        generators.generateFlatItem((Item)ModRegistry.Items.PRINTED_BOOK.get(), ModelTemplates.FLAT_ITEM);
        generators.generateFlatItem((Item)ModRegistry.Items.PRINTED_PAGE.get(), ModelTemplates.FLAT_ITEM);
        generators.generateFlatItem((Item)ModRegistry.Items.PRINTED_PAGES.get(), ModelTemplates.FLAT_ITEM);
    }

    private static void registerPocketComputer(ItemModelGenerators generators, ResourceLocation id, boolean off) {
        ItemModelProvider.createFlatItem(generators, id.withSuffix("_blinking"), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_blink"), id, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_light"));
        ItemModelProvider.createFlatItem(generators, id.withSuffix("_on"), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_on"), id, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_light"));
        if (off) {
            ItemModelProvider.createFlatItem(generators, id, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/pocket_computer_frame"), id);
        }
    }

    private static void registerDisk(ItemModelGenerators generators, Item item) {
        ItemModelProvider.createFlatItem(generators, item, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/disk_frame"), ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"item/disk_colour"));
    }

    private static void createFlatItem(ItemModelGenerators generators, Item item, ResourceLocation ... ids) {
        ItemModelProvider.createFlatItem(generators, ModelLocationUtils.getModelLocation((Item)item), ids);
    }

    private static void createFlatItem(ItemModelGenerators generators, ResourceLocation model, ResourceLocation ... textures) {
        if (textures.length > 5) {
            throw new IndexOutOfBoundsException("Too many layers");
        }
        if (textures.length == 0) {
            throw new IndexOutOfBoundsException("Must have at least one texture");
        }
        if (textures.length == 1) {
            ModelTemplates.FLAT_ITEM.create(model, TextureMapping.layer0((ResourceLocation)textures[0]), generators.output);
            return;
        }
        TextureSlot[] slots = new TextureSlot[textures.length];
        TextureMapping mapping = new TextureMapping();
        for (int i = 0; i < textures.length; ++i) {
            TextureSlot slot = slots[i] = TextureSlot.create((String)("layer" + i));
            mapping.put(slot, textures[i]);
        }
        new ModelTemplate(Optional.of(ResourceLocation.withDefaultNamespace((String)"item/generated")), Optional.empty(), slots).create(model, mapping, generators.output);
    }
}

