/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.ExternalModTags;
import dan200.computercraft.shared.util.RegistryHelper;
import net.minecraft.core.Registry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

class TagProvider {
    TagProvider() {
    }

    public static void blockTags(TagConsumer<Block> tags) {
        tags.tag(ComputerCraftTags.Blocks.COMPUTER).add((Block[])new Block[]{(Block)ModRegistry.Blocks.COMPUTER_NORMAL.get(), (Block)ModRegistry.Blocks.COMPUTER_ADVANCED.get(), (Block)ModRegistry.Blocks.COMPUTER_COMMAND.get()});
        tags.tag(ComputerCraftTags.Blocks.TURTLE).add((Block[])new Block[]{(Block)ModRegistry.Blocks.TURTLE_NORMAL.get(), (Block)ModRegistry.Blocks.TURTLE_ADVANCED.get()});
        tags.tag(ComputerCraftTags.Blocks.WIRED_MODEM).add((Block[])new Block[]{(Block)ModRegistry.Blocks.CABLE.get(), (Block)ModRegistry.Blocks.WIRED_MODEM_FULL.get()});
        tags.tag(ComputerCraftTags.Blocks.MONITOR).add((Block[])new Block[]{(Block)ModRegistry.Blocks.MONITOR_NORMAL.get(), (Block)ModRegistry.Blocks.MONITOR_ADVANCED.get()});
        tags.tag(ComputerCraftTags.Blocks.PERIPHERAL_HUB_IGNORE).addTag(ComputerCraftTags.Blocks.WIRED_MODEM);
        tags.tag(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE).addTag((TagKey<Block>)BlockTags.LEAVES).add((Block[])new Block[]{Blocks.BAMBOO, Blocks.BAMBOO_SAPLING});
        tags.tag(ComputerCraftTags.Blocks.TURTLE_SHOVEL_BREAKABLE).addTag((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL).add((Block[])new Block[]{Blocks.MELON, Blocks.PUMPKIN, Blocks.CARVED_PUMPKIN, Blocks.JACK_O_LANTERN});
        tags.tag(ComputerCraftTags.Blocks.TURTLE_HOE_BREAKABLE).addTag((TagKey<Block>)BlockTags.CROPS).addTag((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE).add((Block[])new Block[]{Blocks.CACTUS, Blocks.MELON, Blocks.PUMPKIN, Blocks.CARVED_PUMPKIN, Blocks.JACK_O_LANTERN});
        tags.tag(ComputerCraftTags.Blocks.TURTLE_SWORD_BREAKABLE).addTag((TagKey<Block>)BlockTags.WOOL).add(Blocks.COBWEB);
        tags.tag(ComputerCraftTags.Blocks.TURTLE_CAN_USE).addTag((TagKey<Block>)BlockTags.BEEHIVES).addTag((TagKey<Block>)BlockTags.CAULDRONS).add(Blocks.COMPOSTER);
        tags.tag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE).add((Block[])new Block[]{(Block)ModRegistry.Blocks.COMPUTER_NORMAL.get(), (Block)ModRegistry.Blocks.COMPUTER_ADVANCED.get(), (Block)ModRegistry.Blocks.TURTLE_NORMAL.get(), (Block)ModRegistry.Blocks.TURTLE_ADVANCED.get(), (Block)ModRegistry.Blocks.SPEAKER.get(), (Block)ModRegistry.Blocks.DISK_DRIVE.get(), (Block)ModRegistry.Blocks.PRINTER.get(), (Block)ModRegistry.Blocks.MONITOR_NORMAL.get(), (Block)ModRegistry.Blocks.MONITOR_ADVANCED.get(), (Block)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get(), (Block)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get(), (Block)ModRegistry.Blocks.WIRED_MODEM_FULL.get(), (Block)ModRegistry.Blocks.CABLE.get()});
        tags.tag((TagKey<Block>)BlockTags.WITHER_IMMUNE).add((Block)ModRegistry.Blocks.COMPUTER_COMMAND.get());
        tags.tag(ExternalModTags.Blocks.CREATE_BRITTLE).add((Block[])new Block[]{(Block)ModRegistry.Blocks.CABLE.get(), (Block)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get(), (Block)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get()});
    }

    public static void itemTags(ItemTagConsumer tags) {
        tags.copy(ComputerCraftTags.Blocks.COMPUTER, ComputerCraftTags.Items.COMPUTER);
        tags.copy(ComputerCraftTags.Blocks.TURTLE, ComputerCraftTags.Items.TURTLE);
        tags.tag(ComputerCraftTags.Items.WIRED_MODEM).add((Item[])new Item[]{(Item)ModRegistry.Items.WIRED_MODEM.get(), (Item)ModRegistry.Items.WIRED_MODEM_FULL.get()});
        tags.copy(ComputerCraftTags.Blocks.MONITOR, ComputerCraftTags.Items.MONITOR);
        tags.tag(ComputerCraftTags.Items.DYEABLE).addTag(ComputerCraftTags.Items.TURTLE).add((Item[])new Item[]{(Item)ModRegistry.Items.DISK.get(), (Item)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), (Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()});
        tags.tag(ItemTags.PIGLIN_LOVED).add((Item)ModRegistry.Items.COMPUTER_ADVANCED.get(), (Item)ModRegistry.Items.TURTLE_ADVANCED.get(), (Item)ModRegistry.Items.WIRELESS_MODEM_ADVANCED.get(), (Item)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get(), (Item)ModRegistry.Items.MONITOR_ADVANCED.get());
        tags.tag(ItemTags.BOOKSHELF_BOOKS).add((Item)ModRegistry.Items.PRINTED_BOOK.get());
        tags.tag(ComputerCraftTags.Items.TURTLE_CAN_PLACE).add(Items.GLASS_BOTTLE).addTag((TagKey<Item>)ItemTags.BOATS);
    }

    public static interface TagConsumer<T> {
        public TagAppender<T> tag(TagKey<T> var1);
    }

    public record TagAppender<T>(Registry<T> registry, TagBuilder builder) {
        public TagAppender<T> add(T object) {
            this.builder.addElement(RegistryHelper.getKeyOrThrow(this.registry, object));
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(T ... objects) {
            for (T object : objects) {
                this.add(object);
            }
            return this;
        }

        public TagAppender<T> addTag(TagKey<T> tag) {
            this.builder.addTag(tag.location());
            return this;
        }
    }

    static interface ItemTagConsumer
    extends TagConsumer<Item> {
        public void copy(TagKey<Block> var1, TagKey<Item> var2);
    }
}

