/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.util.ComponentMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComputerBlockEntity
extends AbstractComputerBlockEntity {
    @Nullable
    private IPeripheral peripheral;

    public ComputerBlockEntity(BlockEntityType<? extends ComputerBlockEntity> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state, family);
    }

    @Override
    protected ServerComputer createComputer(int id) {
        return new ServerComputer((ServerLevel)this.getLevel(), this.getBlockPos(), id, this.label, this.getFamily(), Config.computerTermWidth, Config.computerTermHeight, ComponentMap.empty());
    }

    protected boolean isUsableByPlayer(Player player) {
        return this.isUsable(player);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ComputerBlock.FACING);
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
        BlockState existing = this.getBlockState();
        if (existing.getValue(ComputerBlock.STATE) != newState) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)existing.setValue(ComputerBlock.STATE, (Comparable)((Object)newState)), 2);
        }
    }

    @Override
    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        if (localSide == ComputerSide.RIGHT) {
            return ComputerSide.LEFT;
        }
        if (localSide == ComputerSide.LEFT) {
            return ComputerSide.RIGHT;
        }
        return localSide;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)ModRegistry.Menus.COMPUTER.get()), id, inventory, this::isUsableByPlayer, this.createServerComputer());
    }

    public IPeripheral peripheral() {
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("computer", this);
        return this.peripheral;
    }
}

