/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.core.apis.http.options.InvalidRuleException;
import dan200.computercraft.core.apis.http.options.PartialOptions;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AddressRuleConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AddressRuleConfig.class);
    private static final AddressRule REJECT_ALL = AddressRule.parse("*", OptionalInt.empty(), Action.DENY.toPartial());
    private static final Set<String> knownKeys = Set.of("host", "action", "max_download", "max_upload", "max_websocket_message", "use_proxy");

    AddressRuleConfig() {
    }

    public static List<UnmodifiableConfig> defaultRules() {
        return List.of(AddressRuleConfig.makeRule(config -> {
            config.setComment("host", "The magic \"$private\" host matches all private address ranges, such as localhost and 192.168.0.0/16.\nThis rule prevents computers accessing internal services, and is strongly recommended.");
            config.add("host", (Object)"$private");
            config.setComment("action", "Deny all requests to private IP addresses.");
            config.add("action", (Object)Action.DENY.name().toLowerCase(Locale.ROOT));
        }), AddressRuleConfig.makeRule(config -> {
            config.setComment("host", "The wildcard \"*\" rule matches all remaining hosts.");
            config.add("host", (Object)"*");
            config.setComment("action", "Allow all non-denied hosts.");
            config.add("action", (Object)Action.ALLOW.name().toLowerCase(Locale.ROOT));
            config.setComment("max_download", "The maximum size (in bytes) that a computer can download in a single request.\nNote that responses may receive more data than allowed, but this data will not\nbe returned to the client.");
            config.set("max_download", (Object)0x1000000L);
            config.setComment("max_upload", "The maximum size (in bytes) that a computer can upload in a single request. This\nincludes headers and POST text.");
            config.set("max_upload", (Object)0x400000L);
            config.setComment("max_websocket_message", "The maximum size (in bytes) that a computer can send or receive in one websocket packet.");
            config.set("max_websocket_message", (Object)131072);
            config.setComment("use_proxy", "Enable use of the HTTP/SOCKS proxy if it is configured.");
            config.set("use_proxy", (Object)false);
        }));
    }

    public static UnmodifiableConfig newRule() {
        return AddressRuleConfig.makeRule(config -> {
            config.add("host", (Object)"example.com");
            config.add("action", (Object)Action.DENY.name().toLowerCase(Locale.ROOT));
        });
    }

    private static UnmodifiableConfig makeRule(Consumer<CommentedConfig> setup) {
        CommentedConfig config = InMemoryCommentedFormat.defaultInstance().createConfig(LinkedHashMap::new);
        setup.accept(config);
        return config;
    }

    public static AddressRule parseRule(UnmodifiableConfig builder) {
        try {
            return AddressRuleConfig.doParseRule(builder);
        }
        catch (InvalidRuleException e) {
            LOG.error("Malformed HTTP rule: {} HTTP will NOT work until this is fixed.", (Object)e.getMessage());
            return REJECT_ALL;
        }
    }

    public static AddressRule doParseRule(UnmodifiableConfig builder) {
        String hostObj = AddressRuleConfig.get(builder, "host", String.class).orElse(null);
        if (hostObj == null) {
            throw new InvalidRuleException("No 'host' specified");
        }
        Action action = AddressRuleConfig.getEnum(builder, "action", Action.class).orElse(null);
        OptionalInt port = AddressRuleConfig.unboxOptInt(AddressRuleConfig.get(builder, "port", Number.class));
        OptionalLong maxUpload = AddressRuleConfig.unboxOptLong(AddressRuleConfig.get(builder, "max_upload", Number.class).map(Number::longValue));
        OptionalLong maxDownload = AddressRuleConfig.unboxOptLong(AddressRuleConfig.get(builder, "max_download", Number.class).map(Number::longValue));
        OptionalInt websocketMessage = AddressRuleConfig.unboxOptInt(AddressRuleConfig.get(builder, "max_websocket_message", Number.class).or(() -> AddressRuleConfig.get(builder, "websocket_message", Number.class)).map(Number::intValue));
        Optional<Boolean> useProxy = AddressRuleConfig.get(builder, "use_proxy", Boolean.class);
        List<String> unknownKeys = builder.entrySet().stream().map(UnmodifiableConfig.Entry::getKey).filter(x -> !knownKeys.contains(x)).toList();
        if (!unknownKeys.isEmpty()) {
            LOG.warn("Unknown config {} {} in address rule.", (Object)(unknownKeys.size() == 1 ? "option" : "options"), (Object)String.join((CharSequence)", ", unknownKeys));
        }
        PartialOptions options = new PartialOptions(action, maxUpload, maxDownload, websocketMessage, useProxy);
        return AddressRule.parse(hostObj, port, options);
    }

    private static <T> Optional<T> get(UnmodifiableConfig config, String field, Class<T> klass) {
        Object value = config.get(field);
        if (value == null) {
            return Optional.empty();
        }
        if (klass.isInstance(value)) {
            return Optional.of(klass.cast(value));
        }
        throw new InvalidRuleException(String.format("Field '%s' should be a '%s' but is a %s.", field, klass.getSimpleName(), value.getClass().getSimpleName()));
    }

    private static <T extends Enum<T>> Optional<T> getEnum(UnmodifiableConfig config, String field, Class<T> klass) {
        return AddressRuleConfig.get(config, field, String.class).map(x -> AddressRuleConfig.parseEnum(field, klass, x));
    }

    private static OptionalLong unboxOptLong(Optional<? extends Number> value) {
        return value.map(Number::intValue).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    private static OptionalInt unboxOptInt(Optional<? extends Number> value) {
        return value.map(Number::intValue).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    private static <T extends Enum<T>> T parseEnum(String field, Class<T> klass, String x) {
        for (Enum value : (Enum[])klass.getEnumConstants()) {
            if (!value.name().equalsIgnoreCase(x)) continue;
            return (T)value;
        }
        throw new InvalidRuleException(String.format("Field '%s' should be one of %s, but is '%s'.", field, Arrays.stream((Enum[])klass.getEnumConstants()).map(Enum::name).toList(), x));
    }
}

