/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class ComputerActionServerMessage
extends ComputerServerMessage {
    public static final StreamCodec<RegistryFriendlyByteBuf, ComputerActionServerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ComputerServerMessage::containerId, MoreStreamCodecs.ofEnum(Action.class), x -> x.action, ComputerActionServerMessage::new);
    private final Action action;

    public ComputerActionServerMessage(AbstractContainerMenu menu, Action action) {
        this(menu.containerId, action);
    }

    private ComputerActionServerMessage(int menu, Action action) {
        super(menu);
        this.action = action;
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        switch (this.action.ordinal()) {
            case 0: {
                container.getInput().turnOn();
                break;
            }
            case 2: {
                container.getInput().reboot();
                break;
            }
            case 1: {
                container.getInput().shutdown();
            }
        }
    }

    public CustomPacketPayload.Type<ComputerActionServerMessage> type() {
        return NetworkMessages.COMPUTER_ACTION;
    }

    public static enum Action {
        TURN_ON,
        SHUTDOWN,
        REBOOT;

    }
}

