/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.util.NBTUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class QueueEventServerMessage
extends ComputerServerMessage {
    public static final StreamCodec<RegistryFriendlyByteBuf, QueueEventServerMessage> STREAM_CODEC = StreamCodec.ofMember(QueueEventServerMessage::write, QueueEventServerMessage::new);
    private final String event;
    @Nullable
    private final Object[] args;

    public QueueEventServerMessage(AbstractContainerMenu menu, String event, @Nullable Object[] args) {
        super(menu.containerId);
        this.event = event;
        this.args = args;
    }

    private QueueEventServerMessage(FriendlyByteBuf buf) {
        super(buf.readVarInt());
        this.event = buf.readUtf(Short.MAX_VALUE);
        CompoundTag args = buf.readNbt();
        this.args = args == null ? null : NBTUtil.decodeObjects(args);
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.containerId());
        buf.writeUtf(this.event);
        buf.writeNbt(this.args == null ? null : NBTUtil.encodeObjects(this.args));
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        container.getInput().queueEvent(this.event, this.args);
    }

    public CustomPacketPayload.Type<QueueEventServerMessage> type() {
        return NetworkMessages.QUEUE_EVENT;
    }
}

