/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class WorldUtil {
    private static final double DROP_SPEED = 0.103365;

    public static boolean isLiquidBlock(Level world, BlockPos pos) {
        if (!world.isInWorldBounds(pos)) {
            return false;
        }
        return world.getBlockState(pos).liquid();
    }

    public static boolean isVecInside(VoxelShape shape, Vec3 vec) {
        if (shape.isEmpty()) {
            return false;
        }
        AABB bb = shape.bounds();
        return vec.x >= bb.minX && vec.x <= bb.maxX && vec.y >= bb.minY && vec.y <= bb.maxY && vec.z >= bb.minZ && vec.z <= bb.maxZ;
    }

    public static HitResult clip(Level world, Vec3 from, Vec3 direction, double distance, @Nullable Entity source) {
        Vec3 to = from.add(direction.x * distance, direction.y * distance, direction.z * distance);
        return WorldUtil.clip(world, from, to, source);
    }

    public static HitResult clip(Level world, Vec3 from, Vec3 to, @Nullable Entity source) {
        ContextlessClipContext context = source == null ? new ContextlessClipContext(world, from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE) : new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source);
        BlockHitResult blockHit = world.clip((ClipContext)context);
        double distance = blockHit.getType() == HitResult.Type.MISS ? from.distanceToSqr(to) : blockHit.getLocation().distanceToSqr(from);
        EntityHitResult entityHit = WorldUtil.getEntityHitResult(world, from, to, new AABB(from, to).inflate(1.0), distance, source);
        return entityHit == null ? blockHit : entityHit;
    }

    @Nullable
    private static EntityHitResult getEntityHitResult(Level level, Vec3 from, Vec3 to, AABB bounds, double distanceSq, @Nullable Entity source) {
        if (distanceSq <= 0.0) {
            return null;
        }
        double bestDistance = distanceSq;
        Entity bestEntity = null;
        Vec3 bestHit = null;
        for (Entity entity : level.getEntities(source, bounds, WorldUtil::canCollide)) {
            Vec3 hit;
            double newDistance;
            AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
            if (aabb.contains(from)) {
                bestHit = from;
                bestEntity = entity;
                break;
            }
            Optional clip = aabb.clip(from, to);
            if (clip.isEmpty() || !((newDistance = from.distanceToSqr(hit = (Vec3)clip.get())) < bestDistance)) continue;
            bestEntity = entity;
            bestHit = hit;
            bestDistance = newDistance;
        }
        return bestEntity == null ? null : new EntityHitResult(bestEntity, bestHit);
    }

    private static boolean canCollide(Entity entity) {
        return entity != null && entity.isAlive() && entity.isPickable();
    }

    public static Vec3 getRayStart(Player entity) {
        return entity.getEyePosition();
    }

    public static Vec3 getRayEnd(Player player) {
        return WorldUtil.getRayStart(player).add(player.getLookAngle().scale(player.blockInteractionRange()));
    }

    public static void dropItemStack(Level level, BlockPos pos, @Nullable Direction direction, ItemStack stack) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.getStepX();
            yDir = direction.getStepY();
            zDir = direction.getStepZ();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.getX() + 0.5 + xDir * 0.7;
        double yPos = (double)pos.getY() + 0.5 + yDir * 0.7;
        double zPos = (double)pos.getZ() + 0.5 + zDir * 0.7;
        ItemEntity item = new ItemEntity(level, xPos, yPos, zPos, stack.copy());
        double baseSpeed = level.random.nextDouble() * 0.1 + 0.2;
        item.setDeltaMovement(level.random.triangle(xDir * baseSpeed, 0.103365), level.random.triangle(yDir * baseSpeed, 0.103365), level.random.triangle(zDir * baseSpeed, 0.103365));
        item.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)item);
    }

    private static class ContextlessClipContext
    extends ClipContext {
        private final ClipContext.Block block;

        ContextlessClipContext(Level level, Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid) {
            super(from, to, block, fluid, (Entity)new ItemEntity(EntityType.ITEM, level));
            this.block = block;
        }

        public VoxelShape getBlockShape(BlockState state, BlockGetter level, BlockPos pos) {
            return this.block.get(state, level, pos, CollisionContext.empty());
        }
    }
}

