/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketOpenBuilderGui(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbuilder", (String)"open_builder_gui");
    public static final CustomPacketPayload.Type<PacketOpenBuilderGui> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketOpenBuilderGui> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketOpenBuilderGui::pos, PacketOpenBuilderGui::create);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketOpenBuilderGui create(BlockPos fromTEPos) {
        return new PacketOpenBuilderGui(fromTEPos);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            BlockEntity te = world.getBlockEntity(this.pos);
            if (te == null) {
                return;
            }
            MenuProvider h = (MenuProvider)world.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY, te.getBlockPos(), null);
            player.openMenu(h, buf -> {
                buf.writeBlockPos(this.pos);
                if (h instanceof DefaultContainerProvider) {
                    DefaultContainerProvider provider = (DefaultContainerProvider)h;
                    provider.writeExtraData(buf, te);
                }
            });
        });
    }
}

