/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.RLE;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketReturnShapeData(ShapeID shapeID, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbuilder", (String)"returnshapedata");
    public static final CustomPacketPayload.Type<PacketReturnShapeData> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketReturnShapeData> CODEC = CompositeStreamCodec.composite(ShapeID.STREAM_CODEC, PacketReturnShapeData::shapeID, (StreamCodec)RLE.OPTIONAL_STREAM_CODEC, PacketReturnShapeData::positions, StatePalette.OPTIONAL_STREAM_CODEC, PacketReturnShapeData::statePalette, (StreamCodec)BlockPos.STREAM_CODEC, PacketReturnShapeData::dimension, (StreamCodec)ByteBufCodecs.INT, PacketReturnShapeData::count, (StreamCodec)ByteBufCodecs.INT, PacketReturnShapeData::offsetY, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketReturnShapeData::msg, PacketReturnShapeData::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketReturnShapeData create(ShapeID id, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) {
        return new PacketReturnShapeData(id, positions, statePalette, dimension, count, offsetY, msg);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            int dx = this.dimension.getX();
            int dy = this.dimension.getY();
            int dz = this.dimension.getZ();
            RLE rle = this.positions;
            RenderData.RenderPlane plane = null;
            if (rle != null) {
                BlockState dummy = ((SupportBlock)((Object)((Object)BuilderModule.SUPPORT.get()))).defaultBlockState();
                rle.reset();
                int oy = this.offsetY;
                int y = oy - dy / 2;
                RenderData.RenderStrip[] strips = new RenderData.RenderStrip[dx];
                for (int ox = 0; ox < dx; ++ox) {
                    RenderData.RenderStrip strip;
                    int x = ox - dx / 2;
                    strips[ox] = strip = new RenderData.RenderStrip(x);
                    for (int oz = 0; oz < dz; ++oz) {
                        int data = rle.read();
                        if (data < 255) {
                            if (data == 0) {
                                strip.add(dummy);
                                continue;
                            }
                            strip.add(this.statePalette.getPalette().get(--data));
                            continue;
                        }
                        strip.add(null);
                    }
                    strip.close();
                    plane = new RenderData.RenderPlane(strips, y, oy, -dz / 2, this.count);
                }
            }
            ShapeRenderer.setRenderData(this.shapeID, plane, this.offsetY, dy, this.msg);
        });
    }
}

