/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.client.ClientPlayerKubeEvent;
import dev.latvian.mods.kubejs.client.LangKubeEvent;
import dev.latvian.mods.kubejs.event.EventTargetType;
import dev.latvian.mods.kubejs.plugin.builtin.event.KeyBindEvents;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.StringUtilsWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;

public class KubeJSKeybinds {
    private static final Map<String, KubeKey> REGISTERED = new LinkedHashMap<String, KubeKey>();
    public static final EventTargetType<KubeKey> TARGET = EventTargetType.create(KubeKey.class).identity().transformer(KubeJSKeybinds::get0).describeType(TypeInfo.STRING);

    public static void triggerReload() {
        for (KubeKey key : REGISTERED.values()) {
            key.shouldTick = false;
        }
        KeyBindEvents.TICK.forEachListener(ScriptType.CLIENT, container -> {
            ((KubeKey)container.target).shouldTick = true;
        });
    }

    public static void triggerKeyEvents(Minecraft client) {
        for (KubeKey key : REGISTERED.values()) {
            if (key.mapping == null) continue;
            if (client.kjs$isKeyMappingDown(key.mapping)) {
                if (!key.down) {
                    key.down = true;
                    KeyBindEvents.PRESSED.post(ScriptType.CLIENT, key, new KeyEvent(client.player, key));
                }
                if (key.shouldTick) {
                    KeyBindEvents.TICK.post(ScriptType.CLIENT, key, new TickingKeyEvent(client.player, key));
                }
                ++key.ticksPressed;
                continue;
            }
            if (!key.down) continue;
            key.down = false;
            KeyBindEvents.RELEASED.post(ScriptType.CLIENT, key, new TickingKeyEvent(client.player, key));
            key.ticksPressed = 0;
        }
    }

    @Nullable
    private static KubeKey get0(Object o) {
        return o == null ? null : KubeJSKeybinds.getOrCreate(o.toString());
    }

    @Nullable
    public static KubeKey get(String id) {
        return REGISTERED.get(id);
    }

    public static KubeKey getOrCreate(String id) {
        return REGISTERED.computeIfAbsent(id, KubeKey::new);
    }

    public static void generateLang(LangKubeEvent event) {
        for (KubeKey key : REGISTERED.values()) {
            event.add("kubejs", "key.kubejs." + key.id, StringUtilsWrapper.toTitleCase(key.id));
        }
    }

    public static class KubeKey {
        public final String id;
        public transient KeyMapping mapping;
        public transient boolean down = false;
        private boolean shouldTick = false;
        public transient int ticksPressed = 0;

        public KubeKey(String id) {
            this.id = id;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof KubeKey)) return false;
            KubeKey o = (KubeKey)obj;
            if (!Objects.equals(this.id, o.id)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }
    }

    public static class KeyEvent
    extends ClientPlayerKubeEvent {
        protected final KubeKey key;

        public KeyEvent(LocalPlayer player, KubeKey key) {
            super(player);
            this.key = key;
        }
    }

    public static class TickingKeyEvent
    extends KeyEvent {
        public TickingKeyEvent(LocalPlayer player, KubeKey key) {
            super(player, key);
        }

        public int getTicks() {
            return this.key.ticksPressed;
        }
    }
}

