/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.core.MessageSenderKJS;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.entity.KubeRayTraceResult;
import dev.latvian.mods.kubejs.level.LevelBlock;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.TeleportCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface EntityKJS
extends WithPersistentData,
MessageSenderKJS,
ScriptTypeHolder {
    default public Entity kjs$self() {
        return (Entity)this;
    }

    default public Level kjs$getLevel() {
        return this.kjs$self().level();
    }

    @Nullable
    default public MinecraftServer kjs$getServer() {
        return this.kjs$getLevel().getServer();
    }

    default public String kjs$getType() {
        return this.kjs$self().getType().kjs$getId();
    }

    default public GameProfile kjs$getProfile() {
        return new GameProfile(this.kjs$self().getUUID(), this.kjs$self().getScoreboardName());
    }

    @Override
    default public Component kjs$getName() {
        return this.kjs$self().getName();
    }

    @Override
    default public Component kjs$getDisplayName() {
        return this.kjs$self().getDisplayName();
    }

    @Override
    default public void kjs$tell(Component message) {
        this.kjs$self().sendSystemMessage(message);
    }

    @Override
    default public void kjs$runCommand(String command) {
        Level level = this.kjs$getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getServer().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack(), command);
        }
    }

    @Override
    default public void kjs$runCommandSilent(String command) {
        Level level = this.kjs$getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getServer().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack().withSuppressedOutput(), command);
        }
    }

    default public boolean kjs$isPlayer() {
        return false;
    }

    @Nullable
    default public ItemStack kjs$getItem() {
        return null;
    }

    default public boolean kjs$isFrame() {
        return this instanceof ItemFrame;
    }

    default public boolean kjs$isLiving() {
        return false;
    }

    default public boolean kjs$isMonster() {
        return !this.kjs$self().getType().getCategory().isFriendly();
    }

    default public boolean kjs$isAnimal() {
        return this.kjs$self().getType().getCategory().isPersistent();
    }

    default public boolean kjs$isAmbientCreature() {
        return this.kjs$self().getType().getCategory() == MobCategory.AMBIENT;
    }

    default public boolean kjs$isWaterCreature() {
        return this.kjs$self().getType().getCategory() == MobCategory.WATER_CREATURE;
    }

    default public boolean kjs$isPeacefulCreature() {
        return this.kjs$self().getType().getCategory().isFriendly();
    }

    default public void kjs$setX(double x) {
        this.kjs$setPosition(x, this.kjs$self().getY(), this.kjs$self().getZ());
    }

    default public void kjs$setY(double y) {
        this.kjs$setPosition(this.kjs$self().getX(), y, this.kjs$self().getZ());
    }

    default public void kjs$setZ(double z) {
        this.kjs$setPosition(this.kjs$self().getX(), this.kjs$self().getY(), z);
    }

    default public double kjs$getMotionX() {
        return this.kjs$self().getDeltaMovement().x;
    }

    default public void kjs$setMotionX(double x) {
        Vec3 m = this.kjs$self().getDeltaMovement();
        this.kjs$self().setDeltaMovement(x, m.y, m.z);
    }

    default public double kjs$getMotionY() {
        return this.kjs$self().getDeltaMovement().y;
    }

    default public void kjs$setMotionY(double y) {
        Vec3 m = this.kjs$self().getDeltaMovement();
        this.kjs$self().setDeltaMovement(m.x, y, m.z);
    }

    default public double kjs$getMotionZ() {
        return this.kjs$self().getDeltaMovement().z;
    }

    default public void kjs$setMotionZ(double z) {
        Vec3 m = this.kjs$self().getDeltaMovement();
        this.kjs$self().setDeltaMovement(m.x, m.y, z);
    }

    default public void kjs$teleportTo(ResourceLocation dimension, double x, double y, double z, float yaw, float pitch) {
        Level previousLevel = this.kjs$getLevel();
        ServerLevel level = this.kjs$getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
        if (level == null) {
            throw new IllegalArgumentException("Invalid dimension!");
        }
        if (!Level.isInSpawnableBounds((BlockPos)BlockPos.containing((double)x, (double)y, (double)z))) {
            throw new IllegalArgumentException("Invalid coordinates!");
        }
        if (Float.isNaN(yaw) || Float.isNaN(pitch)) {
            throw new IllegalArgumentException("Invalid rotation!");
        }
        if (level == previousLevel) {
            this.kjs$setPositionAndRotation(x, y, z, yaw, pitch);
            return;
        }
        try {
            TeleportCommand.performTeleport((CommandSourceStack)this.kjs$self().createCommandSourceStack(), (Entity)this.kjs$self(), (ServerLevel)level, (double)x, (double)y, (double)z, Set.of(), (float)yaw, (float)pitch, null);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e.getRawMessage().getString());
        }
    }

    default public void kjs$setPosition(LevelBlock block) {
        this.kjs$teleportTo(block.getDimension(), block.getX(), block.getY(), block.getZ(), this.kjs$self().getYRot(), this.kjs$self().getXRot());
    }

    default public void kjs$setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        this.kjs$self().moveTo(x, y, z, yaw, pitch);
    }

    default public void kjs$setPosition(double x, double y, double z) {
        this.kjs$setPositionAndRotation(x, y, z, this.kjs$self().getYRot(), this.kjs$self().getXRot());
    }

    default public void kjs$setRotation(float yaw, float pitch) {
        this.kjs$setPositionAndRotation(this.kjs$self().getX(), this.kjs$self().getY(), this.kjs$self().getZ(), yaw, pitch);
    }

    default public EntityArrayList kjs$getPassengers() {
        return new EntityArrayList(this.kjs$self().getPassengers());
    }

    default public String kjs$getTeamId() {
        PlayerTeam team = this.kjs$self().getTeam();
        return team == null ? "" : team.getName();
    }

    default public boolean kjs$isOnScoreboardTeam(String teamId) {
        PlayerTeam team = this.kjs$self().getCommandSenderWorld().getScoreboard().getPlayerTeam(teamId);
        return team != null && this.kjs$self().isAlliedTo((Team)team);
    }

    default public Direction kjs$getFacing() {
        if (this.kjs$self().getXRot() > 45.0f) {
            return Direction.DOWN;
        }
        if (this.kjs$self().getXRot() < -45.0f) {
            return Direction.UP;
        }
        return this.kjs$self().getDirection();
    }

    default public LevelBlock kjs$getBlock() {
        return this.kjs$getLevel().kjs$getBlock(this.kjs$self().blockPosition());
    }

    default public CompoundTag kjs$getNbt() {
        CompoundTag nbt = new CompoundTag();
        this.kjs$self().saveWithoutId(nbt);
        return nbt;
    }

    default public void kjs$setNbt(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.kjs$self().load(nbt);
        }
    }

    default public Entity kjs$mergeNbt(@Nullable CompoundTag tag) {
        if (tag == null || tag.isEmpty()) {
            return this.kjs$self();
        }
        CompoundTag nbt = this.kjs$getNbt();
        for (String k : tag.getAllKeys()) {
            Tag t = tag.get(k);
            if (t == null || t == EndTag.INSTANCE) {
                nbt.remove(k);
                continue;
            }
            nbt.put(k, tag.get(k));
        }
        this.kjs$setNbt(nbt);
        return this.kjs$self();
    }

    default public void kjs$playSound(SoundEvent id, float volume, float pitch) {
        this.kjs$getLevel().playSound(null, this.kjs$self().getX(), this.kjs$self().getY(), this.kjs$self().getZ(), id, this.kjs$self().getSoundSource(), volume, pitch);
    }

    default public void kjs$playSound(SoundEvent id) {
        this.kjs$playSound(id, 1.0f, 1.0f);
    }

    default public void kjs$spawn() {
        this.kjs$getLevel().addFreshEntity(this.kjs$self());
    }

    default public void kjs$attack(float hp) {
        this.kjs$self().hurt(this.kjs$self().damageSources().generic(), hp);
    }

    default public double kjs$getDistance(double x, double y, double z) {
        return Math.sqrt(this.kjs$self().distanceToSqr(x, y, z));
    }

    default public double kjs$getDistanceSq(BlockPos pos) {
        return this.kjs$self().distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    default public double kjs$getDistance(BlockPos pos) {
        return Math.sqrt(this.kjs$getDistanceSq(pos));
    }

    default public KubeRayTraceResult kjs$rayTrace(double distance, boolean fluids) {
        double entityDistanceSquared;
        double distanceSquared;
        AABB bound;
        Entity entity = this.kjs$self();
        HitResult hitResult = entity.pick(distance, 0.0f, fluids);
        Vec3 eyePosition = entity.getEyePosition();
        Vec3 lookVector = entity.getViewVector(1.0f);
        Vec3 traceEnd = eyePosition.add(lookVector.x * distance, lookVector.y * distance, lookVector.z * distance);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePosition, (Vec3)traceEnd, (AABB)(bound = entity.getBoundingBox().expandTowards(lookVector.scale(distance)).inflate(1.0, 1.0, 1.0)), ent -> !ent.isSpectator() && ent.isPickable(), (double)(distanceSquared = hitResult.getType() != HitResult.Type.MISS ? hitResult.getLocation().distanceToSqr(eyePosition) : distance * distance));
        if (entityHitResult != null && ((entityDistanceSquared = eyePosition.distanceToSqr(entityHitResult.getLocation())) < distanceSquared || hitResult.getType() == HitResult.Type.MISS)) {
            hitResult = entityHitResult;
        }
        return new KubeRayTraceResult(entity, hitResult, distance);
    }

    default public KubeRayTraceResult kjs$rayTrace(double distance) {
        return this.kjs$rayTrace(distance, true);
    }

    @Nullable
    default public Entity kjs$rayTraceEntity(double distance, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        Vec3 start = this.kjs$self().getEyePosition();
        Vec3 end = start.add(this.kjs$self().getLookAngle().scale(distance));
        for (Entity entity1 : this.kjs$self().level().getEntities(this.kjs$self(), new AABB(start, end), filter == null ? UtilsJS.ALWAYS_TRUE : filter)) {
            double d1;
            AABB aabb = entity1.getBoundingBox();
            Optional optional = aabb.clip(start, end);
            if (optional.isEmpty() || !((d1 = start.distanceToSqr((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    @HideFromJS
    @Nullable
    default public CompoundTag kjs$getRawPersistentData() {
        throw new NoMixinException();
    }

    @HideFromJS
    default public void kjs$setRawPersistentData(@Nullable CompoundTag tag) {
        throw new NoMixinException();
    }

    @Override
    default public ScriptType kjs$getScriptType() {
        return this.kjs$getLevel().kjs$getScriptType();
    }
}

