/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.ingredient.WildcardIngredient;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.item.ItemStackSet;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.filter.RecipeMatchContext;
import dev.latvian.mods.kubejs.recipe.match.ItemMatch;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.util.WithCodec;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface IngredientKJS
extends ItemPredicate,
Replaceable,
WithCodec,
ItemMatch {
    default public Ingredient kjs$self() {
        throw new NoMixinException();
    }

    @Override
    default public ItemStack[] kjs$getStackArray() {
        return this.kjs$self().getItems();
    }

    default public Ingredient kjs$and(Ingredient ingredient) {
        return ingredient == Ingredient.EMPTY ? this.kjs$self() : (this == Ingredient.EMPTY ? ingredient : IntersectionIngredient.of((Ingredient[])new Ingredient[]{this.kjs$self(), ingredient}));
    }

    default public Ingredient kjs$or(Ingredient ingredient) {
        return ingredient == Ingredient.EMPTY ? this.kjs$self() : (this == Ingredient.EMPTY ? ingredient : CompoundIngredient.of((Ingredient[])new Ingredient[]{this.kjs$self(), ingredient}));
    }

    default public Ingredient kjs$except(Ingredient subtracted) {
        return DifferenceIngredient.of((Ingredient)this.kjs$self(), (Ingredient)subtracted);
    }

    default public SizedIngredient kjs$asStack() {
        if (this.kjs$self().isEmpty()) {
            return SizedIngredientWrapper.empty;
        }
        return new SizedIngredient(this.kjs$self(), 1);
    }

    default public SizedIngredient kjs$withCount(int count) {
        return new SizedIngredient(this.kjs$self(), count);
    }

    @Override
    default public boolean kjs$isWildcard() {
        return this.kjs$self().getCustomIngredient() == WildcardIngredient.INSTANCE;
    }

    @Override
    default public Ingredient kjs$asIngredient() {
        return this.kjs$self();
    }

    @Override
    default public Codec<?> getCodec(Context cx) {
        return Ingredient.CODEC;
    }

    @Override
    default public Object replaceThisWith(RecipeScriptContext cx, Object with) {
        Ingredient t = this.kjs$self();
        Ingredient r = IngredientWrapper.wrap(cx.cx(), with);
        if (!r.equals((Object)t)) {
            return r;
        }
        return this;
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, ItemStack item, boolean exact) {
        if (item.isEmpty()) {
            return false;
        }
        if (exact) {
            ItemStackSet stacks = this.kjs$getStacks();
            return stacks.size() == 1 && ItemStack.isSameItemSameComponents((ItemStack)stacks.getFirst(), (ItemStack)item);
        }
        return this.test(item);
    }

    @Override
    default public boolean matches(RecipeMatchContext cx, Ingredient in, boolean exact) {
        if (in == Ingredient.EMPTY) {
            return false;
        }
        if (exact) {
            TagKey<Item> t1 = IngredientWrapper.tagKeyOf(this.kjs$self());
            TagKey<Item> t2 = IngredientWrapper.tagKeyOf(in);
            if (t1 != null && t2 != null) {
                return t1 == t2;
            }
            return this.equals(in);
        }
        try {
            for (ItemStack stack : in.getItems()) {
                if (!this.test(stack)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            throw new KubeRuntimeException("Failed to test ingredient " + String.valueOf(in), ex);
        }
        return false;
    }

    @Nullable
    default public TagKey<Item> kjs$getTagKey() {
        return IngredientWrapper.tagKeyOf(this.kjs$self());
    }

    default public boolean kjs$containsAnyTag() {
        return IngredientWrapper.containsAnyTag(this.kjs$self());
    }

    default public String kjs$toIngredientString(@Nullable DynamicOps<Tag> ops) {
        Ingredient in = this.kjs$self();
        if (in.isEmpty()) {
            return "air";
        }
        ItemStack[] items = this.kjs$getStackArray();
        if (items.length == 0) {
            return "air";
        }
        if (items.length == 1) {
            return items[0].kjs$toItemString0(null);
        }
        return ((Tag)Ingredient.CODEC.encodeStart(ops, (Object)in).getOrThrow()).toString();
    }
}

