/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.plugin.ClassFilter;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ModResourceBindings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;

public class KubeJSPlugins {
    private static final List<KubeJSPlugin> LIST = new ArrayList<KubeJSPlugin>();
    private static final List<String> GLOBAL_CLASS_FILTER = new ArrayList<String>();
    private static final ModResourceBindings BINDINGS = new ModResourceBindings();

    public static void load(List<IModFile> modFiles, boolean loadClientPlugins) {
        try {
            for (IModFile file : modFiles) {
                if (file.getModInfos().isEmpty()) continue;
                KubeJSPlugins.loadMod(((IModInfo)file.getModInfos().getFirst()).getModId(), file, loadClientPlugins);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load KubeJS plugin", ex);
        }
    }

    private static void loadMod(String modId, IModFile mod, boolean loadClientPlugins) throws IOException {
        Path pc;
        Path pp = mod.findResource(new String[]{"kubejs.plugins.txt"});
        if (Files.exists(pp, new LinkOption[0])) {
            KubeJSPlugins.loadFromFile(Files.lines(pp), modId, loadClientPlugins);
        }
        if (Files.exists(pc = mod.findResource(new String[]{"kubejs.classfilter.txt"}), new LinkOption[0])) {
            GLOBAL_CLASS_FILTER.addAll(Files.readAllLines(pc));
        }
        BINDINGS.readBindings(modId, mod);
    }

    private static void loadFromFile(Stream<String> contents, String source, boolean loadClientPlugins) {
        KubeJS.LOGGER.info("Found plugin source {}", (Object)source);
        contents.map(s -> s.split("#", 2)[0].trim()).filter(s -> !s.isBlank()).flatMap(s -> {
            String[] line = s.split(" ");
            for (int i = 1; i < line.length; ++i) {
                if (line[i].equalsIgnoreCase("client")) {
                    if (loadClientPlugins) continue;
                    if (DevProperties.get().logSkippedPlugins) {
                        KubeJS.LOGGER.warn("Plugin {} does not load on server side, skipping", (Object)line[0]);
                    }
                    return Stream.empty();
                }
                if (ModList.get().isLoaded(line[i])) continue;
                if (DevProperties.get().logSkippedPlugins) {
                    KubeJS.LOGGER.warn("Plugin {} does not have required mod '{}' loaded, skipping", (Object)line[0], (Object)line[i]);
                }
                return Stream.empty();
            }
            try {
                return Stream.of(Class.forName(line[0]));
            }
            catch (Throwable t) {
                KubeJS.LOGGER.error("Failed to load plugin {} from source {}: {}", new Object[]{s, source, t});
                t.printStackTrace();
                return Stream.empty();
            }
        }).filter(KubeJSPlugin.class::isAssignableFrom).forEach(c -> {
            try {
                LIST.add((KubeJSPlugin)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable t) {
                KubeJS.LOGGER.error("Failed to init KubeJS plugin {} from source {}: {}", new Object[]{c.getName(), source, t});
            }
        });
    }

    public static ClassFilter createClassFilter(ScriptType type) {
        ClassFilter filter = new ClassFilter(type);
        KubeJSPlugins.forEachPlugin(filter, KubeJSPlugin::registerClasses);
        for (String s : GLOBAL_CLASS_FILTER) {
            if (s.length() < 2) continue;
            if (s.startsWith("+")) {
                filter.allow(s.substring(1).trim());
                continue;
            }
            if (!s.startsWith("-")) continue;
            filter.deny(s.substring(1).trim());
        }
        return filter;
    }

    public static void forEachPlugin(Consumer<KubeJSPlugin> callback) {
        LIST.forEach(callback);
    }

    public static <T> void forEachPlugin(T instance, BiConsumer<KubeJSPlugin, T> callback) {
        for (KubeJSPlugin item : LIST) {
            callback.accept(item, (KubeJSPlugin)instance);
        }
    }

    public static List<KubeJSPlugin> getAll() {
        return Collections.unmodifiableList(LIST);
    }

    public static void addSidedBindings(BindingRegistry event) {
        BINDINGS.addBindings(event);
    }
}

