/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Info(value="Methods for working with Java classes. Reflection my beloved \u2665")
public interface JavaWrapper {
    @Info(value="Loads the specified class, and throws error if class it not found or allowed.\nThe returned object can have public static methods and fields accessed directly from it.\nConstructors can be used with the new keyword.\n")
    public static Object loadClass(KubeJSContext cx, String className) {
        return cx.loadJavaClass(className, true);
    }

    @Info(value="Loads the specified class, and returns null if class is not found or allowed.\nThe returned object can have public static methods and fields accessed directly from it.\nConstructors can be used with the new keyword.\n")
    @Nullable
    public static Object tryLoadClass(KubeJSContext cx, String className) {
        return cx.loadJavaClass(className, false);
    }

    @Info(value="Creates a custom ConsoleJS instance for you to use to, well, log stuff")
    public static ConsoleJS createConsole(KubeJSContext cx, String name) {
        return new ConsoleJS(cx.getType(), LoggerFactory.getLogger((String)name));
    }

    public static <T> T makeFunctionProxy(Context cx, TypeInfo targetClass, BaseFunction function) {
        return Cast.to(cx.createInterfaceAdapter(targetClass, (ScriptableObject)function));
    }

    @Info(value="Cast the object to a target type, use if Rhino can't determine the parameter type due to type erasure.")
    public static <T> T cast(Context cx, Class<T> targetClass, Object object) {
        return Cast.to(cx.jsToJava(object, TypeInfo.of(targetClass)));
    }

    @HideFromJS
    @Nullable
    public static Class<?> tryLoadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <R extends Record> R mergeRecord(Context cx, R original, Map<String, ?> merge) {
        RecordTypeInfo typeInfo = (RecordTypeInfo)TypeInfo.of(original.getClass());
        return original;
    }
}

