/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.universalgrid.neoforge;

import com.ultramega.universalgrid.common.Config;
import com.ultramega.universalgrid.common.UniversalGridIdentifierUtil;
import com.ultramega.universalgrid.common.gui.view.GridTypes;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final Config.WirelessUniversalGridEntry wirelessUniversalGrid = new WirelessUniversalGridEntryImpl();

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public Config.WirelessUniversalGridEntry getWirelessUniversalGrid() {
        return this.wirelessUniversalGrid;
    }

    private static String translationKey(String value) {
        return UniversalGridIdentifierUtil.createUniversalGridTranslationKey("text.autoconfig", "option." + value);
    }

    private class WirelessUniversalGridEntryImpl
    implements Config.WirelessUniversalGridEntry {
        private final ModConfigSpec.LongValue energyCapacity;
        private final ModConfigSpec.EnumValue<GridTypes> gridType;

        WirelessUniversalGridEntryImpl() {
            ConfigImpl.this.builder.translation(ConfigImpl.translationKey("wirelessUniversalGrid")).push("wirelessUniversalGrid");
            this.energyCapacity = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("wirelessUniversalGrid.energyCapacity")).defineInRange("energyCapacity", 1000L, 0L, Long.MAX_VALUE);
            this.gridType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey("wirelessUniversalGrid.gridType")).defineEnum("gridType", (Enum)GridTypes.WIRELESS_GRID);
            ConfigImpl.this.builder.pop();
        }

        @Override
        public long getEnergyCapacity() {
            return (Long)this.energyCapacity.get();
        }

        @Override
        public GridTypes getGridType() {
            return (GridTypes)((Object)this.gridType.get());
        }

        @Override
        public void setGridType(GridTypes gridType) {
            if (gridType != this.gridType.get()) {
                this.gridType.set((Object)gridType);
                ConfigImpl.this.spec.save();
            }
        }
    }
}

