/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.treetap.TreeTap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TapExtractRecipe
implements Recipe<RecipeInput> {
    public final Ingredient input;
    public final ItemStack itemOutput;
    public final ItemStack woodenItemOutput;
    public final ItemStack harvestItem;
    public final boolean collectBucket;
    public final int processingTime;
    public final String fluidColor;
    public final String particleColor;
    public final FluidStack displayFluid;
    public final List<Integer> lifeCycles;
    public final int requiredBlocks;

    public TapExtractRecipe(Ingredient input, ItemStack itemOutput, ItemStack woodenItemOutput, ItemStack harvestItem, boolean collectBucket, int processingTime, FluidStack displayFluid, String fluidColor, String particleColor, int requiredBlocks, List<Integer> lifeCycles) {
        this.input = input;
        this.itemOutput = itemOutput;
        this.woodenItemOutput = woodenItemOutput;
        this.harvestItem = harvestItem;
        this.collectBucket = collectBucket;
        this.processingTime = processingTime;
        this.fluidColor = fluidColor;
        this.particleColor = particleColor;
        this.displayFluid = displayFluid;
        this.requiredBlocks = requiredBlocks;
        this.lifeCycles = lifeCycles;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    @NotNull
    public ItemStack assemble(RecipeInput container, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int w, int h) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(BlockState blockState) {
        boolean woodResult = blockState.is((Block)TreeTap.WOODEN_SAP_COLLECTOR.get());
        return woodResult ? this.woodenItemOutput.copy() : this.itemOutput.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TreeTap.TAP_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)TreeTap.TAP_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TapExtractRecipe> {
        private static final MapCodec<TapExtractRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("log").forGetter(recipe -> recipe.input), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.itemOutput), (App)ItemStack.OPTIONAL_CODEC.fieldOf("wooden_result").orElse((Object)ItemStack.EMPTY).forGetter(recipe -> recipe.woodenItemOutput), (App)ItemStack.OPTIONAL_CODEC.fieldOf("harvest_item").orElse((Object)ItemStack.EMPTY).forGetter(recipe -> recipe.harvestItem), (App)Codec.BOOL.fieldOf("collect_bucket").orElse((Object)false).forGetter(recipe -> recipe.collectBucket), (App)Codec.INT.fieldOf("processing_time").orElse((Object)1000).forGetter(recipe -> recipe.processingTime), (App)FluidStack.CODEC.fieldOf("display_fluid").orElse((Object)new FluidStack((Fluid)Fluids.WATER, 1000)).forGetter(recipe -> recipe.displayFluid), (App)Codec.STRING.fieldOf("fluid_color").orElse((Object)"").forGetter(recipe -> recipe.fluidColor), (App)Codec.STRING.fieldOf("particle_color").orElse((Object)"").forGetter(recipe -> recipe.particleColor), (App)Codec.INT.fieldOf("required_block_count").orElse((Object)1).forGetter(recipe -> recipe.requiredBlocks), (App)Codec.INT.listOf().fieldOf("life_cycle").orElse(List.of(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)).forGetter(recipe -> recipe.lifeCycles)).apply((Applicative)builder, TapExtractRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TapExtractRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TapExtractRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TapExtractRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static TapExtractRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new TapExtractRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), buffer.readBoolean(), buffer.readInt(), (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer), buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readList(FriendlyByteBuf::readInt));
            }
            catch (Exception e) {
                TreeTap.LOGGER.error("Error reading tap extract recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, TapExtractRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.itemOutput);
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.woodenItemOutput);
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.harvestItem);
                buffer.writeBoolean(recipe.collectBucket);
                buffer.writeInt(recipe.processingTime);
                FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.displayFluid);
                buffer.writeUtf(recipe.fluidColor);
                buffer.writeUtf(recipe.particleColor);
                buffer.writeInt(recipe.requiredBlocks);
                buffer.writeCollection(recipe.lifeCycles, FriendlyByteBuf::writeInt);
            }
            catch (Exception e) {
                TreeTap.LOGGER.error("Error writing tap extract recipe to packet.", (Throwable)e);
                throw e;
            }
        }
    }
}

