/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.TextColor;

public class ColorUtil {
    private static final Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();
    private static final Map<String, Integer> stringColorCache = new HashMap<String, Integer>();

    public static Integer getCacheColor(String color) {
        if (!stringColorCache.containsKey(color)) {
            stringColorCache.put(color, ((TextColor)TextColor.parseColor((String)color).result().get()).getValue());
        }
        return stringColorCache.get(color);
    }

    public static float[] getCacheColor(int color) {
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, ColorUtil.getComponents(color));
        }
        return colorCache.get(color);
    }

    public static float[] getComponents(int color) {
        float[] f = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return f;
    }
}

