/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.CraftingHelpers;
import com.zeroregard.ars_technica.helpers.ItemHelpers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class EffectCarve
extends AbstractItemResolveEffect {
    public static EffectCarve INSTANCE = new EffectCarve(ArsTechnica.prefix("glyph_carve"), "Carve");

    private EffectCarve(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double amplifier = spellStats.getAmpMultiplier();
        Map<Item, List<ItemEntity>> groupedItems = entityList.stream().collect(Collectors.groupingBy(itemEntity -> itemEntity.getItem().getItem()));
        for (Map.Entry<Item, List<ItemEntity>> entry : groupedItems.entrySet()) {
            List<ItemEntity> itemEntities = entry.getValue();
            ItemStack exampleStack = itemEntities.get(0).getItem();
            Optional<StonecutterRecipe> cuttingRecipe = this.getStonecuttingRecipe(exampleStack, world, amplifier);
            if (cuttingRecipe.isPresent()) {
                this.carveItemStonecutting(cuttingRecipe.get(), itemEntities, world, pos);
                continue;
            }
            Optional<Recipe<RecipeInput>> sawingRecipe = this.getSawingRecipe(exampleStack, world, amplifier);
            if (!sawingRecipe.isPresent()) continue;
            this.carveItemSawing(sawingRecipe.get(), itemEntities, world, pos);
        }
    }

    private Optional<StonecutterRecipe> getStonecuttingRecipe(ItemStack input, Level world, double amplifier) {
        SingleRecipeInput inputWrapper = new SingleRecipeInput(input);
        String targetType = amplifier < 0.0 ? "slab" : (amplifier > 0.0 ? "wall" : "stairs");
        return world.getRecipeManager().getAllRecipesFor(RecipeType.STONECUTTING).stream().filter(holder -> ((StonecutterRecipe)holder.value()).matches(inputWrapper, world)).map(RecipeHolder::value).filter(recipe -> {
            String resultName = recipe.getResultItem((HolderLookup.Provider)world.registryAccess()).getItem().getDescriptionId().toLowerCase();
            return resultName.contains(targetType);
        }).findFirst();
    }

    private Optional<Recipe<RecipeInput>> getSawingRecipe(ItemStack input, Level world, double amplifier) {
        ItemStackHandler itemHandler = new ItemStackHandler(1);
        itemHandler.setStackInSlot(0, input);
        RecipeWrapper inputWrapper = new RecipeWrapper((IItemHandler)itemHandler);
        String targetType = amplifier < 0.0 ? "slab" : "stairs";
        return world.getRecipeManager().getAllRecipesFor(AllRecipeTypes.CUTTING.getType()).stream().filter(holder -> {
            Recipe recipe = holder.value();
            return recipe instanceof CuttingRecipe && ((CuttingRecipe)recipe).matches(inputWrapper, world);
        }).map(RecipeHolder::value).filter(recipe -> {
            String resultName = recipe.getResultItem((HolderLookup.Provider)world.registryAccess()).getItem().getDescriptionId().toLowerCase();
            return resultName.contains(targetType);
        }).findFirst();
    }

    private void carveItemStonecutting(StonecutterRecipe cuttingRecipe, List<ItemEntity> itemEntities, Level world, BlockPos pos) {
        ItemStack inputItem = ((Ingredient)cuttingRecipe.getIngredients().get(0)).getItems()[0];
        ItemStack outputItem = cuttingRecipe.assemble(new SingleRecipeInput(inputItem), (HolderLookup.Provider)world.registryAccess());
        this.processItemEntities(itemEntities, outputItem, world, pos);
    }

    private void carveItemSawing(Recipe<RecipeInput> sawingRecipe, List<ItemEntity> itemEntities, Level world, BlockPos pos) {
        ItemStack inputItem = ((Ingredient)sawingRecipe.getIngredients().get(0)).getItems()[0];
        ItemStack outputItem = sawingRecipe.assemble((RecipeInput)new SingleRecipeInput(inputItem), (HolderLookup.Provider)world.registryAccess());
        this.processItemEntities(itemEntities, outputItem, world, pos);
    }

    private void processItemEntities(List<ItemEntity> itemEntities, ItemStack outputItem, Level world, BlockPos pos) {
        for (ItemEntity entity : itemEntities) {
            int countToSpawn;
            int inputCount = entity.getItem().getCount();
            if (outputItem.isEmpty()) continue;
            int outputCount = outputItem.getCount();
            int maxStackSize = outputItem.getMaxStackSize();
            for (int totalOutput = inputCount * outputCount; totalOutput > 0; totalOutput -= countToSpawn) {
                countToSpawn = Math.min(totalOutput, maxStackSize);
                ItemStack outputStack = outputItem.copy();
                outputStack.setCount(countToSpawn);
                ItemHelpers.createItemEntity(outputStack, world, pos);
            }
            entity.discard();
        }
    }

    private void setContainerShape(NonNullList<ItemStack> items, ItemStack itemStack, double amplifier) {
        if (amplifier < 0.0) {
            CraftingHelpers.setSlabShape(items, itemStack);
        } else if (amplifier > 0.0) {
            CraftingHelpers.setWallShape(items, itemStack);
        } else {
            CraftingHelpers.setStairsShape(items, itemStack);
        }
    }

    private int getCraftSize(double amplifier) {
        return amplifier < 0.0 ? 3 : 6;
    }

    private void carveItems(Item item, List<ItemEntity> itemEntities, SpellStats spellStats, Level world, BlockPos pos, double amplifier) {
        int craftSize = this.getCraftSize(amplifier);
        int totalItemCount = itemEntities.stream().mapToInt(entity -> entity.getItem().getCount()).sum();
        int totalCarvings = totalItemCount / craftSize;
        NonNullList mutableItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        this.setContainerShape((NonNullList<ItemStack>)mutableItems, new ItemStack((ItemLike)item), amplifier);
        CraftingInput container = CraftingInput.of((int)3, (int)3, List.copyOf(mutableItems));
        for (int i = 0; i < totalCarvings; ++i) {
            ItemStack carvedItem = CraftingHelpers.getItem(container, item, world);
            if (carvedItem.isEmpty()) continue;
            ItemHelpers.createItemEntity(carvedItem, world, pos);
        }
        int totalItemsToRemove = totalCarvings * craftSize;
        ItemHelpers.subtractItemsFromItemEntities(itemEntities, totalItemsToRemove, item, pos, world);
    }

    public int getDefaultManaCost() {
        return 10;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAmplify.INSTANCE, "Changes recipe to walls");
        map.put((AbstractAugment)AugmentDampen.INSTANCE, "Changes recipe to slabs");
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the area in which items get collected for processing");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentDampen.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentDampen.INSTANCE.getRegistryName(), 1);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Shapes identical items, crafting them into stairs. Augment for walls, Dampen for slabs";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

