/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StorageHelpers {
    public static ItemScroll.SortPref canDepositItem(Level level, BlockEntity tile, ItemStack stack) {
        ItemScroll.SortPref pref = ItemScroll.SortPref.LOW;
        if (tile == null || stack == null || stack.isEmpty()) {
            return ItemScroll.SortPref.INVALID;
        }
        IItemHandler handler = StorageHelpers.getItemCapFromTile(level, tile);
        if (handler == null) {
            return ItemScroll.SortPref.INVALID;
        }
        boolean foundFrame = false;
        for (ItemFrame itemFrame : level.getEntitiesOfClass(ItemFrame.class, new AABB(tile.getBlockPos()).inflate(1.0))) {
            Direction facing;
            BlockPos framePos = itemFrame.blockPosition();
            BlockPos attachedBlockPos = framePos.relative((facing = itemFrame.getDirection()).getOpposite());
            BlockEntity adjTile = level.getBlockEntity(attachedBlockPos);
            if (adjTile == null || !adjTile.equals(tile)) continue;
            foundFrame = true;
            ItemStack stackInFrame = itemFrame.getItem();
            if (stackInFrame.isEmpty()) continue;
            Item item = stackInFrame.getItem();
            if (item instanceof ItemScroll) {
                ItemScroll scrollItem = (ItemScroll)item;
                pref = scrollItem.getSortPref(stack, stackInFrame, handler);
                continue;
            }
            if (stackInFrame.getItem().equals(stack.getItem())) {
                pref = ItemScroll.SortPref.HIGHEST;
                continue;
            }
            return ItemScroll.SortPref.INVALID;
        }
        if (foundFrame) {
            return pref;
        }
        return !ItemStack.matches((ItemStack)ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)true), (ItemStack)stack) ? pref : ItemScroll.SortPref.INVALID;
    }

    public static BlockPos getValidStorePos(Level level, List<BlockPos> containerPosTargets, ItemStack stack) {
        if (containerPosTargets.isEmpty() || stack.isEmpty()) {
            return null;
        }
        BlockPos returnPos = null;
        ItemScroll.SortPref foundPref = ItemScroll.SortPref.INVALID;
        for (BlockPos b : containerPosTargets) {
            ItemScroll.SortPref pref = StorageHelpers.sortPrefForStack(level, b, stack);
            if (pref.ordinal() <= foundPref.ordinal()) continue;
            foundPref = pref;
            returnPos = b;
            if (foundPref != ItemScroll.SortPref.HIGHEST) continue;
            return returnPos;
        }
        return returnPos;
    }

    public static List<BlockPos> getValidStorePositions(Level level, List<BlockPos> containerPosTargets, ItemStack stack) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (BlockPos pos : containerPosTargets) {
            if (StorageHelpers.sortPrefForStack(level, pos, stack) == ItemScroll.SortPref.INVALID) continue;
            validPositions.add(pos);
        }
        return validPositions;
    }

    public static ItemScroll.SortPref sortPrefForStack(Level level, @Nullable BlockPos b, ItemStack stack) {
        if (stack == null || stack.isEmpty() || b == null || !level.isLoaded(b)) {
            return ItemScroll.SortPref.INVALID;
        }
        return StorageHelpers.canDepositItem(level, level.getBlockEntity(b), stack);
    }

    @Nullable
    public static IItemHandler getItemCapFromTile(Level level, BlockEntity blockEntity) {
        if (blockEntity != null) {
            return (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, null);
        }
        return null;
    }
}

