/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.client;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    public final ModConfigSpec.ConfigValue<Boolean> showPlacementPreview;
    public final ModConfigSpec.ConfigValue<Double> placementPreviewOpacity;
    public final ModConfigSpec.ConfigValue<Double> nameplateRenderDistance;
    public final ModConfigSpec.ConfigValue<Double> nameplateSneakingRenderDistance;

    public ClientConfig(ModConfigSpec.Builder builder) {
        builder.push("block_rendering");
        this.showPlacementPreview = builder.comment(new String[]{"Whether to preview the state a hyperbox block will be placed as.", "Can be disabled if another placement preview mod is causing compatibility issues with this feature."}).define("show_placement_preview", true);
        this.placementPreviewOpacity = builder.comment("Opacity (alpha value) of hyperbox placement preview").defineInRange("placement_preview_opacity", 0.4, 0.0, 1.0);
        builder.pop();
        builder.push("nameplate_rendering");
        this.nameplateRenderDistance = builder.comment(new String[]{"Minimum distance from a hyperbox to the player to render hyperbox nameplates from while not sneaking.", "If negative, nameplates will not be rendered while not sneaking."}).define("nameplate_render_distance", (Object)-1.0);
        this.nameplateSneakingRenderDistance = builder.comment(new String[]{"Minimum distance from a hyperbox to the player to render hyperbox nameplates from while sneaking.", "If negative, nameplates will not be rendered while sneaking."}).define("nameplate_sneaking_render_distance", (Object)8.0);
        builder.pop();
    }
}

