/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.dimension;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.blocks.ApertureBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;

public class HyperboxChunkGenerator
extends ChunkGenerator {
    public static final ChunkPos CHUNKPOS = new ChunkPos(0, 0);
    public static final long CHUNKID = CHUNKPOS.toLong();
    public static final BlockPos CORNER = CHUNKPOS.getWorldPosition();
    public static final BlockPos CENTER = CORNER.offset(7, 7, 7);
    public static final BlockPos MIN_SPAWN_CORNER = CORNER.offset(1, 1, 1);
    public static final BlockPos MAX_SPAWN_CORNER = CORNER.offset(13, 12, 13);
    private final Holder<Biome> biome;

    public Holder<Biome> biome() {
        return this.biome;
    }

    public static MapCodec<HyperboxChunkGenerator> makeCodec() {
        return Biome.CODEC.fieldOf("biome").xmap(HyperboxChunkGenerator::new, HyperboxChunkGenerator::biome);
    }

    public int getHeight() {
        return 15;
    }

    public HyperboxChunkGenerator(MinecraftServer server) {
        this((Holder<Biome>)server.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Hyperbox.BIOME_KEY));
    }

    public HyperboxChunkGenerator(Holder<Biome> biome) {
        super((BiomeSource)new FixedBiomeSource(biome));
        this.biome = biome;
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return Hyperbox.INSTANCE.hyperboxChunkGeneratorCodec.get();
    }

    public void applyCarvers(WorldGenRegion world, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carvingStep) {
    }

    public void buildSurface(WorldGenRegion worldGenRegion, StructureManager structureFeatureManager, RandomState random, ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.getPos();
        if (chunkPos.equals((Object)CHUNKPOS)) {
            BlockState wallState = Hyperbox.INSTANCE.hyperboxWall.get().defaultBlockState();
            BlockPos.MutableBlockPos mutaPos = new BlockPos.MutableBlockPos();
            mutaPos.set((Vec3i)CORNER);
            int maxHorizontal = 14;
            int ceilingY = this.getHeight() - 1;
            for (int xOff = 0; xOff <= maxHorizontal; ++xOff) {
                int worldX = CORNER.getX() + xOff;
                for (int zOff = 0; zOff <= maxHorizontal; ++zOff) {
                    int worldZ = CORNER.getZ() + zOff;
                    if (xOff == 0 || xOff == maxHorizontal || zOff == 0 || zOff == maxHorizontal) {
                        for (int y = 1; y < ceilingY; ++y) {
                            mutaPos.set(worldX, y, worldZ);
                            chunk.setBlockState((BlockPos)mutaPos, wallState, false);
                        }
                    }
                    mutaPos.set(worldX, 0, worldZ);
                    chunk.setBlockState((BlockPos)mutaPos, wallState, false);
                    mutaPos.set(worldX, ceilingY, worldZ);
                    chunk.setBlockState((BlockPos)mutaPos, wallState, false);
                }
            }
            BlockState aperture = Hyperbox.INSTANCE.apertureBlock.get().defaultBlockState();
            Consumer<Direction> apertureSetter = dir -> chunk.setBlockState((BlockPos)mutaPos, (BlockState)aperture.setValue((Property)ApertureBlock.FACING, (Comparable)dir), false);
            int centerX = CENTER.getX();
            int centerY = CENTER.getY();
            int centerZ = CENTER.getZ();
            int west = centerX - 7;
            int east = centerX + 7;
            int down = centerY - 7;
            int up = centerY + 7;
            int north = centerZ - 7;
            int south = centerZ + 7;
            mutaPos.set(centerX, up, centerZ);
            apertureSetter.accept(Direction.DOWN);
            mutaPos.set(centerX, down, centerZ);
            apertureSetter.accept(Direction.UP);
            mutaPos.set(centerX, centerY, south);
            apertureSetter.accept(Direction.NORTH);
            mutaPos.set(centerX, centerY, north);
            apertureSetter.accept(Direction.SOUTH);
            mutaPos.set(east, centerY, centerZ);
            apertureSetter.accept(Direction.WEST);
            mutaPos.set(west, centerY, centerZ);
            apertureSetter.accept(Direction.EAST);
        }
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public int getGenDepth() {
        return 16;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState random, StructureManager structures, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int getSeaLevel() {
        return 0;
    }

    public int getMinY() {
        return 0;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState random) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> stringsToRender, RandomState random, BlockPos pos) {
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel level, HolderSet<Structure> structures, BlockPos pos, int range, boolean skipKnownStructures) {
        return null;
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunkAccess, StructureManager structures) {
    }

    public int getSpawnHeight(LevelHeightAccessor level) {
        return 1;
    }

    public void createReferences(WorldGenLevel world, StructureManager structures, ChunkAccess chunk) {
    }
}

