/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.jei;

import com.github.minecraftschurlimods.bibliocraft.BCConfig;
import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.client.jei.DyedColorSubtypeInterpreter;
import com.github.minecraftschurlimods.bibliocraft.client.jei.PrintingTableRecipeCategory;
import com.github.minecraftschurlimods.bibliocraft.client.screen.FancyCrafterScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.PrintingTableScreen;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterMenu;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMenu;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCMenus;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.github.minecraftschurlimods.bibliocraft.util.CompatUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.github.minecraftschurlimods.bibliocraft.util.holder.ColoredDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.holder.ColoredWoodTypeDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.holder.GroupingDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.holder.WoodTypeDeferredHolder;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.Lazy;

@JeiPlugin
public final class BCJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = BCUtil.bcLoc("jei_plugin");
    private static final Lazy<BibliocraftWoodType> OAK = Lazy.of(() -> BibliocraftApi.getWoodTypeRegistry().get(BCUtil.mcLoc("oak")));
    private static final DyeColor WHITE = DyeColor.WHITE;
    private static final Lazy<List<WoodTypeDeferredHolder<Item, ?>>> WOOD_TYPE_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.BOOKCASE, BCItems.FANCY_ARMOR_STAND, BCItems.FANCY_CLOCK, BCItems.FANCY_CRAFTER, BCItems.GRANDFATHER_CLOCK, BCItems.LABEL, BCItems.POTION_SHELF, BCItems.SHELF, BCItems.TABLE, BCItems.TOOL_RACK));
    private static final Lazy<List<ColoredDeferredHolder<Item, ?>>> COLORED_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.FANCY_GOLD_LAMP, BCItems.FANCY_IRON_LAMP, BCItems.FANCY_GOLD_LANTERN, BCItems.FANCY_IRON_LANTERN));
    private static final Lazy<List<ColoredWoodTypeDeferredHolder<Item, ?>>> COLORED_WOOD_TYPE_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.DISPLAY_CASE, BCItems.SEAT, BCItems.SMALL_SEAT_BACK, BCItems.RAISED_SEAT_BACK, BCItems.FLAT_SEAT_BACK, BCItems.TALL_SEAT_BACK, BCItems.FANCY_SEAT_BACK));

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)BCItems.SWORD_PEDESTAL.get(), (ISubtypeInterpreter)DyedColorSubtypeInterpreter.INSTANCE);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PrintingTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!((Boolean)BCConfig.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
            for (GroupingDeferredHolder holder : (List)WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                registration.addIngredientInfo((ItemLike)((WoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get()), new Component[]{Translations.ALL_WOOD_TYPES});
            }
        }
        if (!((Boolean)BCConfig.JEI_SHOW_COLOR_TYPES.get()).booleanValue()) {
            if (!((Boolean)BCConfig.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    registration.addIngredientInfo((ItemLike)((ColoredWoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get(), WHITE), new Component[]{Translations.ALL_COLORS_AND_WOOD_TYPES});
                }
            } else {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    for (BibliocraftWoodType woodType : BibliocraftApi.getWoodTypeRegistry().getAll()) {
                        registration.addIngredientInfo((ItemLike)((ColoredWoodTypeDeferredHolder)holder).get(woodType, WHITE), new Component[]{Translations.ALL_COLORS});
                    }
                }
            }
            for (GroupingDeferredHolder holder : (List)COLORED_DEFERRED_HOLDERS.get()) {
                registration.addIngredientInfo((ItemLike)((ColoredDeferredHolder)holder).get(WHITE), new Component[]{Translations.ALL_COLORS});
            }
        }
        registration.addRecipes(PrintingTableRecipeCategory.TYPE, ClientUtil.getLevel().getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)BCRecipes.PRINTING_TABLE.get()));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(FancyCrafterMenu.class, BCMenus.FANCY_CRAFTER.get(), RecipeTypes.CRAFTING, 0, 9, 10, 44);
        registration.addRecipeTransferHandler(PrintingTableMenu.class, BCMenus.PRINTING_TABLE.get(), PrintingTableRecipeCategory.TYPE, 0, 10, 11, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (((Boolean)BCConfig.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
            registration.addRecipeCatalysts(RecipeTypes.CRAFTING, (ItemLike[])BCItems.FANCY_CRAFTER.values().toArray(ItemLike[]::new));
        } else {
            registration.addRecipeCatalysts(RecipeTypes.CRAFTING, new ItemLike[]{(ItemLike)BCItems.FANCY_CRAFTER.get((BibliocraftWoodType)OAK.get())});
        }
        registration.addRecipeCatalysts(PrintingTableRecipeCategory.TYPE, new ItemLike[]{BCItems.PRINTING_TABLE, BCItems.IRON_PRINTING_TABLE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FancyCrafterScreen.class, 88, 32, 28, 23, new RecipeType[]{RecipeTypes.CRAFTING});
        registration.addRecipeClickArea(PrintingTableScreen.class, 108, 28, 28, 23, new RecipeType[]{PrintingTableRecipeCategory.TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        if (!((Boolean)BCConfig.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
            for (GroupingDeferredHolder holder : (List)WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                this.removeAllExcept(runtime, holder, (Item)((WoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get()));
            }
        }
        if (!((Boolean)BCConfig.JEI_SHOW_COLOR_TYPES.get()).booleanValue()) {
            if (!((Boolean)BCConfig.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    this.removeAllExcept(runtime, holder, (Item)((ColoredWoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get(), WHITE));
                }
            } else {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    for (BibliocraftWoodType woodType : BibliocraftApi.getWoodTypeRegistry().getAll()) {
                        this.removeAllExcept(runtime, holder, (Item)((ColoredWoodTypeDeferredHolder)holder).get(woodType, WHITE));
                    }
                }
            }
            for (GroupingDeferredHolder holder : (List)COLORED_DEFERRED_HOLDERS.get()) {
                this.removeAllExcept(runtime, holder, (Item)((ColoredDeferredHolder)holder).get(WHITE));
            }
        }
        if (!CompatUtil.hasSoulCandles()) {
            this.remove(runtime, Stream.of(BCItems.SOUL_FANCY_GOLD_LANTERN, BCItems.SOUL_FANCY_IRON_LANTERN).map(Supplier::get).map(ItemStack::new).toList());
        }
    }

    private void remove(IJeiRuntime runtime, List<ItemStack> list) {
        runtime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, list);
    }

    private void removeAllExcept(IJeiRuntime runtime, GroupingDeferredHolder<Item, ?> holder, Item except) {
        this.remove(runtime, holder.values().stream().filter(e -> e != except).map(ItemStack::new).toList());
    }
}

