/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.screen.BCMenuScreen;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.Translations;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCMenu;
import com.github.minecraftschurlimods.bibliocraft.util.slot.HasToggleableSlots;
import com.github.minecraftschurlimods.bibliocraft.util.slot.ToggleableSlot;
import com.github.minecraftschurlimods.bibliocraft.util.slot.ToggleableSlotSyncPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BCScreenWithToggleableSlots<T extends BCMenu<?>>
extends BCMenuScreen<T> {
    private static final ResourceLocation DISABLED_SLOT = BCUtil.mcLoc("container/crafter/disabled_slot");
    private final Player player;

    public BCScreenWithToggleableSlots(T menu, Inventory inventory, Component title, ResourceLocation background) {
        super(menu, inventory, title, background);
        this.player = inventory.player;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.hoveredSlot instanceof ToggleableSlot && !((HasToggleableSlots)((Object)((BCMenu)this.menu))).isSlotDisabled(this.hoveredSlot.index) && ((BCMenu)this.menu).getCarried().isEmpty() && !this.hoveredSlot.hasItem() && !this.player.isSpectator()) {
            graphics.renderTooltip(this.font, Translations.VANILLA_TOGGLABLE_SLOT, mouseX, mouseY);
        }
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot instanceof ToggleableSlot && ((HasToggleableSlots)((Object)((BCMenu)this.menu))).isSlotDisabled(slot.index)) {
            graphics.blitSprite(DISABLED_SLOT, slot.x - 1, slot.y - 1, 18, 18);
            return;
        }
        super.renderSlot(graphics, slot);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof ToggleableSlot && !slot.hasItem() && !this.player.isSpectator()) {
            switch (type) {
                case PICKUP: {
                    if (((HasToggleableSlots)((Object)((BCMenu)this.menu))).isSlotDisabled(slotId)) {
                        this.setSlotDisabled(slotId, false);
                        break;
                    }
                    if (!((BCMenu)this.menu).getCarried().isEmpty()) break;
                    this.setSlotDisabled(slotId, true);
                    break;
                }
                case SWAP: {
                    ItemStack stack = this.player.getInventory().getItem(mouseButton);
                    if (!((HasToggleableSlots)((Object)((BCMenu)this.menu))).isSlotDisabled(slotId) || stack.isEmpty()) break;
                    this.setSlotDisabled(slotId, false);
                }
            }
        }
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    protected void setSlotDisabled(int slot, boolean disabled) {
        ((HasToggleableSlots)((Object)((BCMenu)this.menu))).setSlotDisabled(slot, disabled);
        PacketDistributor.sendToServer((CustomPacketPayload)new ToggleableSlotSyncPacket(((BCMenu)this.menu).getBlockEntity().getBlockPos(), slot, disabled), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.4f, disabled ? 0.75f : 1.0f);
    }
}

