/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand;

import com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand.FancyArmorStandBlock;
import com.github.minecraftschurlimods.bibliocraft.content.fancyarmorstand.FancyArmorStandBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.init.BCEntities;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class FancyArmorStandEntity
extends ArmorStand {
    private FancyArmorStandBlockEntity blockEntity;

    public FancyArmorStandEntity(EntityType<? extends ArmorStand> entityType, Level level) {
        super(entityType, level);
    }

    public FancyArmorStandEntity(Level level, FancyArmorStandBlockEntity blockEntity) {
        this(BCEntities.FANCY_ARMOR_STAND.get(), level);
        this.blockEntity = blockEntity;
    }

    public boolean isInvisible() {
        return true;
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public float getYHeadRot() {
        if (this.blockEntity == null) {
            return super.getYHeadRot();
        }
        Direction facing = (Direction)this.blockEntity.getBlockState().getValue((Property)FancyArmorStandBlock.FACING);
        return facing.getAxis() == Direction.Axis.Z ? facing.getOpposite().toYRot() : facing.toYRot();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return slot.isArmor() && this.blockEntity != null ? this.blockEntity.getItem(3 - slot.getIndex()) : super.getItemBySlot(slot);
    }
}

