/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancycrafter;

import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterBlock;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterMenu;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCMenuBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.slot.HasToggleableSlots;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class FancyCrafterBlockEntity
extends BCMenuBlockEntity
implements HasToggleableSlots {
    private static final String CRAFTING_TICKS_REMAINING_KEY = "crafting_ticks_remaining";
    private static final String DISABLED_SLOTS_KEY = "disabled_slots";
    private static final int SLOT_DISABLED = 1;
    private static final int SLOT_ENABLED = 0;
    private static final int MAX_CRAFTING_TICKS = 6;
    private final boolean[] disabledSlots = new boolean[9];
    private final InvWrapper wrapper = new InvWrapper(this, this){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot == 9 ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 9 ? ItemStack.EMPTY : super.extractItem(slot, amount, simulate);
        }
    };
    private int craftingTicksRemaining = 6;
    private RecipeHolder<CraftingRecipe> recipe;

    public FancyCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(BCBlockEntities.FANCY_CRAFTER.get(), 18, FancyCrafterBlockEntity.defaultName("fancy_crafter"), pos, state);
    }

    public int getRedstoneSignal() {
        return (int)IntStream.range(0, 9).filter(i -> !this.getItem(i).isEmpty() || this.isSlotDisabled(i)).count();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FancyCrafterBlockEntity blockEntity) {
        if (blockEntity.recipe == null) {
            return;
        }
        CraftingRecipe recipe = (CraftingRecipe)blockEntity.recipe.value();
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        ItemStack resultStack = blockEntity.getItem(9);
        if (!(resultStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)resultStack) && result.getCount() + resultStack.getCount() <= result.getMaxStackSize())) {
            return;
        }
        --blockEntity.craftingTicksRemaining;
        if (blockEntity.craftingTicksRemaining > 0) {
            return;
        }
        CraftingInput input = CraftingInput.of((int)3, (int)3, blockEntity.getInputs());
        ItemStack assembled = recipe.assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        assembled.onCraftedBySystem(level);
        blockEntity.setItem(9, blockEntity.tryDispense(level, pos, assembled, state));
        blockEntity.craftingTicksRemaining = 6;
        recipe.getRemainingItems((RecipeInput)CraftingInput.of((int)3, (int)3, blockEntity.getInputs())).stream().filter(e -> !e.isEmpty()).forEach(e -> blockEntity.tryDispense(level, pos, (ItemStack)e, state));
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(blockEntity.getInputs().stream().filter(e -> !e.isEmpty()).toList());
        for (int i = 10; i < 18; ++i) {
            ItemStack stack = blockEntity.getItem(i);
            if (stack.isEmpty()) continue;
            ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
            for (ItemStack e2 : inputs) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)e2, (ItemStack)stack) || e2.getCount() >= e2.getMaxStackSize() || stack.isEmpty()) continue;
                e2.grow(1);
                toRemove.add(e2);
                stack.shrink(1);
            }
            toRemove.forEach(inputs::remove);
        }
        blockEntity.getInputs().stream().filter(e -> !e.isEmpty()).forEach(e -> e.shrink(1));
        blockEntity.setChanged();
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (this.isSlotDisabled(slot) && !stack.isEmpty()) {
            this.disabledSlots[slot] = false;
        }
        super.setItem(slot, stack);
        this.calculateRecipe();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (stack.hasCraftingRemainingItem() || this.isSlotDisabled(slot)) {
            return false;
        }
        ItemStack slotStack = this.getItem(slot);
        return slotStack.isEmpty() || slotStack.getCount() < slotStack.getMaxStackSize() && !this.smallerStackExists(slotStack.getCount(), stack, slot);
    }

    @Override
    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new FancyCrafterMenu(id, inventory, this);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.craftingTicksRemaining = tag.getInt(CRAFTING_TICKS_REMAINING_KEY);
        int[] tagSlots = tag.getIntArray(DISABLED_SLOTS_KEY);
        for (int i = 0; i < 9; ++i) {
            this.disabledSlots[i] = this.canDisableSlot(i) && tagSlots[i] == 1;
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt(CRAFTING_TICKS_REMAINING_KEY, this.craftingTicksRemaining);
        int[] tagSlots = new int[9];
        for (int i = 0; i < 9; ++i) {
            tagSlots[i] = this.disabledSlots[i] ? 1 : 0;
        }
        tag.putIntArray(DISABLED_SLOTS_KEY, tagSlots);
    }

    @Override
    public IItemHandler getCapability(@Nullable Direction side) {
        return this.wrapper;
    }

    @Override
    public void setSlotDisabled(int slot, boolean disabled) {
        if (!this.canDisableSlot(slot)) {
            return;
        }
        this.disabledSlots[slot] = disabled;
        this.setChanged();
    }

    @Override
    public boolean isSlotDisabled(int slot) {
        return this.isCraftingSlot(slot) && this.disabledSlots[slot];
    }

    @Override
    public boolean canDisableSlot(int slot) {
        return this.isCraftingSlot(slot) && this.items.getStackInSlot(slot).isEmpty();
    }

    private boolean isCraftingSlot(int slot) {
        return slot >= 0 && slot < 9;
    }

    private boolean smallerStackExists(int currentSize, ItemStack stack, int slot) {
        for (int i = slot + 1; i < 9; ++i) {
            ItemStack slotStack;
            if (this.isSlotDisabled(i) || !(slotStack = this.getItem(i)).isEmpty() && (slotStack.getCount() >= currentSize || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack))) continue;
            return true;
        }
        return false;
    }

    private void calculateRecipe() {
        RecipeManager recipes = this.level().getRecipeManager();
        CraftingInput input = CraftingInput.of((int)3, (int)3, this.getInputs());
        this.recipe = recipes.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, this.level()).orElse(null);
        this.items.setStackInSlot(9, this.recipe == null ? ItemStack.EMPTY : ((CraftingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.level().registryAccess()).copy());
    }

    private ItemStack tryDispense(Level level, BlockPos pos, ItemStack stack, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FancyCrafterBlock.FACING);
        stack = BCUtil.tryInsert(level, pos, direction, stack, this);
        if (!stack.isEmpty() && !level.isClientSide() && level.getBlockState(pos.above()).getCollisionShape((BlockGetter)level, pos.above()).isEmpty()) {
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos.above());
            ItemEntity entity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), stack);
            level.addFreshEntity((Entity)entity);
            level.playSound(null, pos, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemStack.EMPTY;
        }
        return stack;
    }

    private List<ItemStack> getInputs() {
        return IntStream.range(0, 9).mapToObj(this::getItem).toList();
    }
}

