/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record EnchantmentLevelsNumberProvider(DataComponentType<?> dataComponent, NumberProvider normalCost, Optional<NumberProvider> treasureCost, Map<Holder<Enchantment>, Either<NumberProvider, LevelBasedValue>> overrides) implements NumberProvider
{
    public static final MapCodec<EnchantmentLevelsNumberProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DataComponentType.CODEC.fieldOf("data_component").forGetter(EnchantmentLevelsNumberProvider::dataComponent), (App)NumberProviders.CODEC.fieldOf("normal_cost").forGetter(EnchantmentLevelsNumberProvider::normalCost), (App)NumberProviders.CODEC.optionalFieldOf("treasure_cost").forGetter(EnchantmentLevelsNumberProvider::treasureCost), (App)Codec.unboundedMap((Codec)Enchantment.CODEC, (Codec)Codec.either((Codec)NumberProviders.CODEC, (Codec)LevelBasedValue.CODEC)).optionalFieldOf("overrides", Map.of()).forGetter(EnchantmentLevelsNumberProvider::overrides)).apply((Applicative)inst, EnchantmentLevelsNumberProvider::new));

    public EnchantmentLevelsNumberProvider(DataComponentType<?> dataComponent, NumberProvider normalCost, NumberProvider treasureCost) {
        this(dataComponent, normalCost, Optional.of(treasureCost), Map.of());
    }

    public float getFloat(LootContext context) {
        ItemStack stack = (ItemStack)context.getParam(LootContextParams.TOOL);
        if (stack.isEmpty() || !stack.has(this.dataComponent)) {
            return 0.0f;
        }
        Object object = stack.get(this.dataComponent);
        if (!(object instanceof ItemEnchantments)) {
            return 0.0f;
        }
        ItemEnchantments enchantments = (ItemEnchantments)object;
        float cost = 0.0f;
        for (Holder enchantment : enchantments.keySet()) {
            int level = enchantments.getLevel(enchantment);
            if (this.overrides.containsKey(enchantment)) {
                cost += ((Float)Either.unwrap((Either)this.overrides.get(enchantment).mapBoth(e -> Float.valueOf(e.getFloat(context) * (float)level), e -> Float.valueOf(e.calculate(level))))).floatValue();
                continue;
            }
            if (this.treasureCost.isPresent() && enchantment.is(EnchantmentTags.TREASURE)) {
                cost += this.treasureCost.get().getFloat(context) * (float)level;
                continue;
            }
            cost += this.normalCost.getFloat(context) * (float)level;
        }
        return cost;
    }

    public int getInt(LootContext lootContext) {
        float value = this.getFloat(lootContext);
        return value <= 0.0f ? 0 : (value <= 1.0f ? 1 : (int)value);
    }

    public LootNumberProviderType getType() {
        return BCRecipes.ENCHANTMENT_LEVELS_NUMBER_PROVIDER.get();
    }
}

