/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PrintingTableSetRecipePacket(BlockPos pos, int duration, int maxDuration, int levelCost) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PrintingTableSetRecipePacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("printing_table_set_recipe"));
    public static final StreamCodec<ByteBuf, PrintingTableSetRecipePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PrintingTableSetRecipePacket::pos, (StreamCodec)ByteBufCodecs.INT, PrintingTableSetRecipePacket::duration, (StreamCodec)ByteBufCodecs.INT, PrintingTableSetRecipePacket::maxDuration, (StreamCodec)ByteBufCodecs.INT, PrintingTableSetRecipePacket::levelCost, PrintingTableSetRecipePacket::new);

    public void handle(IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof PrintingTableBlockEntity)) {
            return;
        }
        PrintingTableBlockEntity blockEntity2 = (PrintingTableBlockEntity)blockEntity;
        if (level.isClientSide()) {
            blockEntity2.setFromPacket(this);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PrintingTableSetRecipePacket(this.pos, blockEntity2.getDuration(), blockEntity2.getMaxDuration(), blockEntity2.getLevelCost()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

