/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.block;

import dev.su5ed.mffs.block.BaseEntityBlock;
import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BiometricIdentifierBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)13.0, (double)16.0), Block.box((double)12.0, (double)5.0, (double)12.0, (double)16.0, (double)13.0, (double)16.0)});
    private final Map<BlockState, VoxelShape> shapesCache = this.getShapeForEachState(state -> ModUtil.rotateShape(Direction.NORTH, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), SHAPE));

    public BiometricIdentifierBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<? extends BaseBlockEntity>>)ModObjects.BIOMETRIC_IDENTIFIER_BLOCK_ENTITY);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }
}

