/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.blockentity;

import dev.su5ed.mffs.blockentity.BaseBlockEntity;
import dev.su5ed.mffs.util.inventory.InventorySlot;
import dev.su5ed.mffs.util.inventory.InventorySlotItemHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class InventoryBlockEntity
extends BaseBlockEntity {
    protected final InventorySlotItemHandler items = new InventorySlotItemHandler(this::onInventoryChanged);

    protected InventoryBlockEntity(BlockEntityType<? extends BaseBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public InventorySlotItemHandler getItems() {
        return this.items;
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode) {
        return this.addSlot(name, mode, stack -> true);
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter) {
        return this.items.addSlot(name, mode, filter);
    }

    protected InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        return this.items.addSlot(name, mode, filter, onChanged);
    }

    protected InventorySlot addVirtualSlot(String name) {
        return this.items.addSlot(name, InventorySlot.Mode.NONE, stack -> true, stack -> {}, true);
    }

    protected void onInventoryChanged() {
    }

    @Override
    public void provideAdditionalDrops(List<? super ItemStack> drops) {
        super.provideAdditionalDrops(drops);
        drops.addAll(this.items.getAllItems());
    }

    public boolean mergeIntoInventory(ItemStack stack) {
        if (!this.level.isClientSide && !stack.isEmpty()) {
            Direction side;
            IItemHandler handler;
            ItemStack remainder = stack;
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            for (int i = 0; !(i >= n || (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.worldPosition.relative(side = directionArray[i]), (Object)side.getOpposite())) != null && (remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)remainder, (boolean)false)).isEmpty()); ++i) {
            }
            if (!remainder.isEmpty()) {
                ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, remainder);
                this.level.addFreshEntity((Entity)item);
            }
        }
        return false;
    }

    @Override
    protected void saveCommonTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveCommonTag(tag, provider);
        tag.put("items", (Tag)this.items.serializeNBT(provider));
    }

    @Override
    protected void loadCommonTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadCommonTag(tag, provider);
        this.items.deserializeNBT(provider, tag.getCompound("items"));
    }
}

