/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import com.google.common.base.Suppliers;
import dev.su5ed.mffs.setup.ModClientSetup;
import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class BaseItem
extends Item {
    private final Supplier<Component> description;

    public BaseItem(ExtendedItemProperties properties) {
        super(properties.properties);
        this.description = properties.description != null ? Suppliers.memoize(() -> properties.description.apply(this)) : null;
    }

    protected void appendHoverTextPre(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        this.appendHoverTextPre(stack, context, tooltipComponents, isAdvanced);
        if (this.description != null) {
            if (ModClientSetup.hasShiftDown()) {
                tooltipComponents.add(this.description.get());
            } else {
                tooltipComponents.add((Component)ModUtil.translate("info", "show_details", ModUtil.translate("info", "key.shift", new Object[0]).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public static class ExtendedItemProperties {
        private final Item.Properties properties;
        private Function<Item, Component> description;

        public ExtendedItemProperties(Item.Properties properties) {
            this.properties = properties;
        }

        public ExtendedItemProperties description() {
            this.description = item -> {
                String name = BuiltInRegistries.ITEM.getKey(item).getPath();
                return ModUtil.translate("item", name + ".description", new Object[0]).withStyle(ChatFormatting.GRAY);
            };
            return this;
        }
    }
}

