/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.su5ed.mffs.MFFSMod;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public final class BlockEntityRenderDelegate {
    public static final BlockEntityRenderDelegate INSTANCE = new BlockEntityRenderDelegate();
    private final Map<BlockEntity, DelegateRendererInfo> renderDelegates = new HashMap<BlockEntity, DelegateRendererInfo>();

    private BlockEntityRenderDelegate() {
    }

    public void putDelegateFor(BlockEntity originalBlockEntity, BlockState delegateState) {
        Block block;
        if (this.renderDelegates.containsKey(originalBlockEntity)) {
            DelegateRendererInfo delegateInfo = this.renderDelegates.get(originalBlockEntity);
            if (delegateInfo.delegateBlockEntity.getBlockState().is(delegateState.getBlock())) {
                delegateInfo.delegateBlockEntity.setBlockState(delegateState);
                return;
            }
        }
        if (delegateState != null && (block = delegateState.getBlock()) instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft mc = Minecraft.getInstance();
            BlockEntity delegateBe = entityBlock.newBlockEntity(BlockPos.ZERO, delegateState);
            if (delegateBe != null) {
                delegateBe.setLevel((Level)mc.level);
                BlockEntityRenderer delegateBeRenderer = mc.getBlockEntityRenderDispatcher().getRenderer(delegateBe);
                if (delegateBeRenderer != null) {
                    this.renderDelegates.put(originalBlockEntity, new DelegateRendererInfo(delegateBe, (BlockEntityRenderer<? super BlockEntity>)delegateBeRenderer));
                }
            }
        }
    }

    public void removeDelegateOf(BlockEntity originalBlockEntity) {
        this.renderDelegates.remove(originalBlockEntity);
    }

    public void tryRenderDelegate(BlockEntity originalBlockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalBlockEntity);
        if (delegateRendererInfo != null) {
            try {
                PoseStack copyPose = new PoseStack();
                copyPose.pushPose();
                copyPose.last().pose().mul((Matrix4fc)pose.last().pose());
                copyPose.last().normal().mul((Matrix3fc)pose.last().normal());
                delegateRendererInfo.delegateRenderer().render(delegateRendererInfo.delegateBlockEntity(), partialTicks, copyPose, buffer, combinedLight, combinedOverlay);
                copyPose.popPose();
            }
            catch (Exception e) {
                MFFSMod.LOGGER.warn("Error rendering delegate BlockEntity {}: {}", (Object)delegateRendererInfo.delegateBlockEntity(), (Object)e);
                this.removeDelegateOf(originalBlockEntity);
            }
        }
    }

    private record DelegateRendererInfo(BlockEntity delegateBlockEntity, BlockEntityRenderer<? super BlockEntity> delegateRenderer) {
    }
}

