/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.inventory;

import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InventorySlotItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final Runnable onChanged;
    private final List<InventorySlot> slots = new ArrayList<InventorySlot>();

    public InventorySlotItemHandler(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter) {
        return this.addSlot(name, mode, filter, stack -> {});
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        return this.addSlot(name, mode, filter, onChanged, false);
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged, boolean virtual) {
        InventorySlot slot = new InventorySlot(this, name, mode, filter, onChanged, virtual);
        this.slots.add(slot);
        return slot;
    }

    public void onChanged() {
        this.onChanged.run();
    }

    public Collection<ItemStack> getAllItems() {
        return ((StreamEx)((StreamEx)StreamEx.of(this.slots).remove(InventorySlot::isVirtual)).map(InventorySlot::getItem).remove(ItemStack::isEmpty)).toList();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.slots.get(slot).setItem(stack);
    }

    public int getSlots() {
        return this.slots.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).getItem();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).insert(stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).extract(amount, simulate);
    }

    public int getSlotLimit(int slot) {
        this.validateSlotIndex(slot);
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).accepts(stack);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        this.slots.forEach(slot -> nbt.put(slot.getName(), slot.getItem().saveOptional(provider)));
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.slots.forEach(slot -> {
            if (nbt.contains(slot.getName())) {
                CompoundTag tag = nbt.getCompound(slot.getName());
                slot.setItem(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag), false);
            }
        });
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }
}

